/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms.validation;

import com.zuunr.forms.FormField;
import com.zuunr.forms.formfield.Type;
import com.zuunr.forms.validation.FormFieldValidationResult;
import com.zuunr.json.JsonValue;
import java.math.BigDecimal;

public class DecimalValidator {
    public FormFieldValidationResult.Builder validate(FormField param, JsonValue fieldValue, Boolean returnWaste, FormFieldValidationResult.Builder fieldValidationBuilder) {
        BigDecimal decimalValue;
        block3: {
            decimalValue = null;
            try {
                decimalValue = fieldValue.asBigDecimal();
            }
            catch (Exception e) {
                fieldValidationBuilder.valid(false);
                if (!returnWaste.booleanValue()) break block3;
                fieldValidationBuilder.add("type", Type.DECIMAL.asJsonValue());
            }
        }
        if (decimalValue != null) {
            fieldValidationBuilder = this.validateMin(param.asJsonValue(), decimalValue, returnWaste, fieldValidationBuilder);
            fieldValidationBuilder = this.validateMax(param.asJsonValue(), decimalValue, returnWaste, fieldValidationBuilder);
        }
        return fieldValidationBuilder;
    }

    private FormFieldValidationResult.Builder validateMin(JsonValue formField, BigDecimal value, boolean returnWaste, FormFieldValidationResult.Builder formFieldValidationBuilder) {
        JsonValue minJsonValue = formField.get("min", JsonValue.NULL);
        BigDecimal min = minJsonValue.asBigDecimal();
        if (min != null && this.lessThan(value, min)) {
            formFieldValidationBuilder.valid(false);
            if (returnWaste) {
                formFieldValidationBuilder.add("min", minJsonValue);
            }
        }
        return formFieldValidationBuilder;
    }

    private FormFieldValidationResult.Builder validateMax(JsonValue formField, BigDecimal value, boolean returnWaste, FormFieldValidationResult.Builder formFieldValidationBuilder) {
        JsonValue maxJsonValue = formField.get("max", JsonValue.NULL);
        BigDecimal max = maxJsonValue.asBigDecimal();
        if (max != null && this.greaterThan(value, max)) {
            formFieldValidationBuilder.valid(false);
            if (returnWaste) {
                formFieldValidationBuilder.add("max", maxJsonValue);
            }
        }
        return formFieldValidationBuilder;
    }

    protected boolean lessThan(BigDecimal bigDecimal1, BigDecimal bigDecimal2) {
        return bigDecimal1.compareTo(bigDecimal2) < 0;
    }

    protected boolean greaterThan(BigDecimal bigDecimal1, BigDecimal bigDecimal2) {
        return bigDecimal1.compareTo(bigDecimal2) > 0;
    }
}

