/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms.validation;

import com.zuunr.forms.formfield.FormFieldMember;
import com.zuunr.json.JsonArray;
import com.zuunr.json.JsonObject;
import com.zuunr.json.JsonObjectSupport;
import com.zuunr.json.JsonValue;

public class FormFieldValidationResult
implements JsonObjectSupport {
    public final boolean valid;
    public final JsonArray path;
    public final String description;
    public final JsonValue badValue;
    public final JsonObject violations;
    public final boolean addParamToFiltrate;
    private JsonObject asJsonObject;

    public FormFieldValidationResult(boolean valid, JsonArray path, String description, JsonValue badValue, JsonObject violations, boolean addParamToFiltrate) {
        this.valid = valid;
        this.path = path;
        this.description = description;
        this.badValue = badValue;
        this.violations = violations;
        this.addParamToFiltrate = addParamToFiltrate;
        this.asJsonObject = this.asJsonObject;
    }

    public JsonObject asJsonObject() {
        if (this.asJsonObject == null) {
            JsonObject temp = JsonObject.EMPTY.put("path", this.path).put("badValue", this.badValue).put("violations", this.violations);
            if (this.description != null) {
                temp = temp.put("description", this.description);
            }
            this.asJsonObject = temp;
        }
        return this.asJsonObject;
    }

    public JsonValue asJsonValue() {
        return this.asJsonObject().jsonValue();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(FormFieldValidationResult formFieldValidationResult) {
        return new Builder().valid(formFieldValidationResult.valid).path(formFieldValidationResult.path).description(formFieldValidationResult.description).badValue(formFieldValidationResult.badValue).violations(formFieldValidationResult.violations).addParamToFiltrate(formFieldValidationResult.addParamToFiltrate);
    }

    public static class Builder {
        private boolean valid = true;
        private JsonArray path;
        private String description;
        private JsonValue badValue;
        private boolean addParamToFiltrate;
        private JsonObject.JsonObjectBuilder violations;

        public Builder addParamToFiltrate(boolean addParamToFiltrate) {
            this.addParamToFiltrate = addParamToFiltrate;
            return this;
        }

        public Builder path(JsonArray path) {
            this.path = path;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder badValue(JsonValue badValue) {
            this.badValue = badValue;
            return this;
        }

        public Builder add(String validationName, JsonValue violation) {
            this.violations = this.violations == null ? JsonObject.EMPTY.builder() : this.violations;
            this.violations.put(validationName, violation);
            return this;
        }

        public Builder add(String validationName, FormFieldMember violation) {
            this.violations = this.violations == null ? JsonObject.EMPTY.builder() : this.violations;
            this.violations.put(validationName, violation.asJsonValue());
            return this;
        }

        public Builder valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        private Builder violations(JsonObject violations) {
            this.violations = violations.builder();
            return this;
        }

        public FormFieldValidationResult build() {
            return new FormFieldValidationResult(this.isValid(), this.path, this.description, this.badValue, this.violations == null ? JsonObject.EMPTY : this.violations.build(), this.addParamToFiltrate);
        }

        public boolean containsViolations() {
            return this.violations != null && !this.violations.isEmpty();
        }

        public boolean isValid() {
            return (this.violations == null || this.violations.isEmpty()) && this.valid;
        }

        public boolean addParamToFiltrate() {
            return this.addParamToFiltrate;
        }
    }
}

