/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms.validation;

import com.zuunr.forms.FormField;
import com.zuunr.forms.filter.FormFilter;
import com.zuunr.forms.filter.ValidationContext;
import com.zuunr.forms.filter.result.Waste;
import com.zuunr.forms.formfield.Options;
import com.zuunr.forms.formfield.options.AggregatedValidationStep;
import com.zuunr.forms.formfield.options.Option;
import com.zuunr.forms.validation.FormFieldValidationResult;
import com.zuunr.json.JsonArray;
import com.zuunr.json.JsonObject;
import com.zuunr.json.JsonValue;
import com.zuunr.json.JsonValueSupport;

public class OptionsValidator {
    public FormFieldValidationResult.Builder validate(FormField formField, JsonValue fieldValue, Boolean returnWaste, FormFieldValidationResult.Builder fieldValidationBuilder, FormFilter formFilter, ValidationContext validationContext) {
        Options options = formField.options();
        if (options != null) {
            if (options.value() == null) {
                throw new RuntimeException("options form field member must have value (Json Array of forms or values)");
            }
            JsonArray.JsonArrayBuilder errors = null;
            boolean success = false;
            if (formField.options().aggregatedValidationSteps() == null || formField.options().aggregatedValidationSteps().asList().isEmpty()) {
                success = false;
                for (Option option : formField.options().value().asList()) {
                    if (option.value() == null) {
                        if (option.format() == null) {
                            throw new RuntimeException("format must not be null when value is null");
                        }
                        Waste waste = formFilter.filter(option.format(), fieldValue, true, validationContext);
                        if (waste.isEmpty()) {
                            success = true;
                            break;
                        }
                        if (errors == null) {
                            errors = JsonArray.EMPTY.builder();
                        }
                        errors.add(JsonObject.EMPTY.builder().put("label", option.label()).put("error", (JsonValueSupport)waste).build());
                        continue;
                    }
                    if (option.value().equals((Object)fieldValue)) {
                        success = true;
                        break;
                    }
                    if (errors == null) {
                        errors = JsonArray.EMPTY.builder();
                    }
                    errors.add((JsonValueSupport)option);
                }
            } else {
                JsonObject succeedingOptionsPerLabel = formField.options().perLabel();
                for (AggregatedValidationStep validationStep : formField.options().aggregatedValidationSteps().asList()) {
                    success = false;
                    errors = null;
                    for (String label : succeedingOptionsPerLabel.keys().asList(String.class)) {
                        Option validationStepOption = (Option)validationStep.asJsonObject().get(label, JsonValue.NULL).as(Option.class);
                        if (validationStepOption == null) {
                            success = true;
                            break;
                        }
                        if (validationStepOption.format() == null) {
                            throw new RuntimeException("format must not be null!");
                        }
                        Waste waste = formFilter.filter(validationStepOption.format(), fieldValue, true, validationContext);
                        if (waste.isEmpty()) {
                            success = true;
                            continue;
                        }
                        if (errors == null) {
                            errors = JsonArray.EMPTY.builder();
                        }
                        errors.add(JsonObject.EMPTY.builder().put("label", validationStepOption.label()).put("error", (JsonValueSupport)waste).build());
                        succeedingOptionsPerLabel = succeedingOptionsPerLabel.remove(label);
                    }
                    if (succeedingOptionsPerLabel.size() != 0) continue;
                    success = false;
                    break;
                }
            }
            if (!success) {
                fieldValidationBuilder.add("options", formField.options().asJsonObject().put("value", errors.build()).remove("aggregatedValidationSteps").jsonValue());
            }
        }
        return fieldValidationBuilder;
    }
}

