/*
 * Decompiled with CFR 0.152.
 */
package com.zuunr.forms.validation;

import com.zuunr.forms.FormField;
import com.zuunr.forms.formfield.Max;
import com.zuunr.forms.formfield.Min;
import com.zuunr.forms.formfield.Pattern;
import com.zuunr.forms.validation.FormFieldValidationResult;
import com.zuunr.json.JsonValue;

public class StringValidator {
    private static final JsonValue STRING = JsonValue.of((String)"string");

    public FormFieldValidationResult.Builder validate(FormField formField, JsonValue fieldValue, Boolean returnWaste, FormFieldValidationResult.Builder fieldValidationBuilder) {
        if (fieldValue.is(String.class)) {
            Integer maxlength;
            Integer minlength = formField.minlength().asInteger();
            if (minlength > ((String)fieldValue.getValue(String.class)).length()) {
                fieldValidationBuilder.valid(false);
                if (returnWaste.booleanValue()) {
                    fieldValidationBuilder.add("minlength", formField.asJsonObject().get("minlength"));
                }
            }
            if ((maxlength = formField.maxlength().asInteger()) < ((String)fieldValue.getValue(String.class)).length()) {
                fieldValidationBuilder.valid(false);
                if (returnWaste.booleanValue()) {
                    fieldValidationBuilder.add("maxlength", formField.asJsonObject().get("maxlength"));
                }
            }
            this.min(formField, fieldValue, returnWaste, fieldValidationBuilder);
            this.max(formField, fieldValue, returnWaste, fieldValidationBuilder);
            Pattern pattern = formField.pattern();
            if (pattern != null && !pattern.compiled().matcher((CharSequence)fieldValue.getValue(String.class)).matches()) {
                fieldValidationBuilder.valid(false);
                if (returnWaste.booleanValue()) {
                    fieldValidationBuilder.add("pattern", pattern.asJsonValue());
                }
            }
        } else {
            fieldValidationBuilder.valid(false);
            if (returnWaste.booleanValue()) {
                fieldValidationBuilder.add("type", STRING);
            }
        }
        return fieldValidationBuilder;
    }

    private FormFieldValidationResult.Builder min(FormField formField, JsonValue fieldValue, Boolean returnWaste, FormFieldValidationResult.Builder fieldValidationBuilder) {
        Min min = formField.min();
        if (min != null) {
            String minString = min.asString();
            if (((String)fieldValue.getValue(String.class)).compareTo(minString) < 0) {
                fieldValidationBuilder.valid(false);
                if (returnWaste.booleanValue()) {
                    fieldValidationBuilder.add("min", formField.asJsonObject().get("min"));
                }
            }
        }
        return fieldValidationBuilder;
    }

    private FormFieldValidationResult.Builder max(FormField formField, JsonValue fieldValue, Boolean returnWaste, FormFieldValidationResult.Builder fieldValidationBuilder) {
        Max max = formField.max();
        if (max != null) {
            String maxString = max.asString();
            if (((String)fieldValue.getValue(String.class)).compareTo(maxString) > 0) {
                fieldValidationBuilder.valid(false);
                if (returnWaste.booleanValue()) {
                    fieldValidationBuilder.add("max", formField.asJsonObject().get("max"));
                }
            }
        }
        return fieldValidationBuilder;
    }
}

