/*
 * Decompiled with CFR 0.152.
 */
package community.flock.wirespec.integration.spring.kotlin.configuration;

import community.flock.wirespec.integration.spring.kotlin.client.WirespecWebClient;
import community.flock.wirespec.kotlin.Wirespec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@ConditionalOnClass(value={WebClient.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0017J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\nH\u0017R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lcommunity/flock/wirespec/integration/spring/kotlin/configuration/WirespecWebClientConfiguration;", "", "serialization", "Lcommunity/flock/wirespec/kotlin/Wirespec$Serialization;", "", "<init>", "(Lcommunity/flock/wirespec/kotlin/Wirespec$Serialization;)V", "getSerialization", "()Lcommunity/flock/wirespec/kotlin/Wirespec$Serialization;", "defaultWebClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "wirespecWebClient", "Lcommunity/flock/wirespec/integration/spring/kotlin/client/WirespecWebClient;", "webClient", "spring"})
public class WirespecWebClientConfiguration {
    @NotNull
    private final Wirespec.Serialization<String> serialization;

    public WirespecWebClientConfiguration(@NotNull Wirespec.Serialization<String> serialization) {
        Intrinsics.checkNotNullParameter(serialization, (String)"serialization");
        this.serialization = serialization;
    }

    @NotNull
    public final Wirespec.Serialization<String> getSerialization() {
        return this.serialization;
    }

    @Bean
    @ConditionalOnMissingBean(name={"wirespecSpringWebClient"})
    @NotNull
    public WebClient defaultWebClient() {
        WebClient webClient = WebClient.builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"build(...)");
        return webClient;
    }

    @Bean
    @ConditionalOnMissingBean(value={WirespecWebClient.class})
    @NotNull
    public WirespecWebClient wirespecWebClient(@Qualifier(value="wirespecSpringWebClient") @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        return new WirespecWebClient(webClient, this.serialization);
    }
}

