/*
 * Decompiled with CFR 0.152.
 */
package consulting.omnia.util.classloader;

import consulting.omnia.util.cast.CastUtil;
import consulting.omnia.util.classloader.elements.Directory;
import consulting.omnia.util.classloader.visitor.DirectoryTypeScanner;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassLoaderScanner {
    private final String packageName;
    private final List<Class<?>> foundTypes;

    public ClassLoaderScanner(String packageName) {
        this.packageName = packageName;
        this.foundTypes = new LinkedList();
    }

    public ClassLoaderScanner() {
        this(null);
    }

    public <R> List<Class<R>> scan(Class<R> type) throws IOException, ClassNotFoundException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String _packageName = this.nullSafePackageName(this.packageName);
        Enumeration<URL> resources = contextClassLoader.getResources(_packageName);
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String path = resource.getPath();
            if (path == null || path.isEmpty()) continue;
            if ("file".equalsIgnoreCase(resource.getProtocol())) {
                Directory rootDir = new Directory(new File(path));
                DirectoryTypeScanner scanner = new DirectoryTypeScanner(type, _packageName);
                this.foundTypes.addAll(scanner.scan(rootDir));
            }
            if (resource.getProtocol() == null || !resource.getProtocol().toLowerCase().contains("jar")) continue;
            JarURLConnection jarUrlConnection = (JarURLConnection)resource.openConnection();
            JarFile jar = jarUrlConnection.getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            boolean foundPackage = false;
            while (entries.hasMoreElements()) {
                JarEntry nextElement = entries.nextElement();
                if (foundPackage && nextElement.getName().contains(".class")) {
                    String className = nextElement.getName().replace(".class", "").replace("/", ".");
                    Class<?> loadClass = contextClassLoader.loadClass(className);
                    if (!type.isAssignableFrom(loadClass)) continue;
                    this.foundTypes.add(loadClass);
                    continue;
                }
                if (_packageName.isEmpty() || !nextElement.getName().startsWith(_packageName) || !nextElement.isDirectory() || foundPackage) continue;
                foundPackage = true;
            }
        }
        return CastUtil.getAsList(this.foundTypes);
    }

    private String nullSafePackageName(String packageName) {
        return packageName == null ? "" : packageName.replace(".", "/");
    }
}

