/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.web;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.thread.ExecutorBuilder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.alibaba.ttl.threadpool.TtlExecutors;
import cool.happycoding.code.web.HappyWebProperties;
import cool.happycoding.code.web.exception.GlobalExceptionHandler;
import cool.happycoding.code.web.exception.HappyErrorController;
import cool.happycoding.code.web.fastjson.CustomerFastJsonConfig;
import cool.happycoding.code.web.fastjson.FastJsonConfigCustomizer;
import cool.happycoding.code.web.jackson2.CustomerJackson2Config;
import cool.happycoding.code.web.jackson2.Jackson2ConfigCustomizer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@AutoConfigureBefore(value={ErrorMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={HappyWebProperties.class})
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
public class HappyWebAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public GlobalExceptionHandler globalExceptionHandler() {
        return new GlobalExceptionHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public HappyErrorController happyErrorController(ErrorAttributes errorAttributes) {
        return new HappyErrorController(errorAttributes);
    }

    @Bean
    @ConditionalOnProperty(name={"happy.code.web.converter-type"}, havingValue="jackson2")
    public Jackson2ObjectMapperBuilderCustomizer jackson2ObjectMapperBuilderCustomizer(HappyWebProperties happyWebProperties, ObjectProvider<List<Jackson2ConfigCustomizer>> jackson2ConfigCustomizerProvider) {
        CustomerJackson2Config customerJackson2Config = new CustomerJackson2Config(happyWebProperties);
        List jackson2ConfigCustomizers = (List)jackson2ConfigCustomizerProvider.getIfAvailable();
        if (CollUtil.isNotEmpty((Collection)jackson2ConfigCustomizers)) {
            assert (jackson2ConfigCustomizers != null);
            jackson2ConfigCustomizers.forEach(jackson2ConfigCustomizer -> jackson2ConfigCustomizer.customize(customerJackson2Config));
        }
        return customerJackson2Config;
    }

    @Bean
    @ConditionalOnClass(value={JSON.class, HttpMessageConverter.class})
    @ConditionalOnProperty(name={"happy.code.web.converter-type"}, havingValue="fastjson", matchIfMissing=true)
    public HttpMessageConverters fastJsonHttpMessageConverter(HappyWebProperties happyWebProperties, ObjectProvider<List<FastJsonConfigCustomizer>> fastJsonConfigCustomizerProvider) {
        FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
        List supportedMediaTypes = MediaType.parseMediaTypes((String)"application/json");
        fastConverter.setSupportedMediaTypes(supportedMediaTypes);
        FastJsonConfig fastJsonConfig = new CustomerFastJsonConfig(happyWebProperties).fastJsonConfig();
        List fastJsonConfigCustomizers = (List)fastJsonConfigCustomizerProvider.getIfAvailable();
        if (CollUtil.isNotEmpty((Collection)fastJsonConfigCustomizers)) {
            assert (fastJsonConfigCustomizers != null);
            fastJsonConfigCustomizers.forEach(fastJsonConfigCustomizer -> fastJsonConfigCustomizer.customize(fastJsonConfig));
        }
        fastConverter.setFastJsonConfig(fastJsonConfig);
        return new HttpMessageConverters(new HttpMessageConverter[]{fastConverter});
    }

    @Bean(value={"happyThreadPoolExecutor"})
    public Executor happyThreadPoolExecutor(HappyWebProperties happyWebProperties) {
        ThreadPoolExecutor executorService = ExecutorBuilder.create().setCorePoolSize(happyWebProperties.getPool().getCorePoolSize()).setMaxPoolSize(happyWebProperties.getPool().getMaxPoolSize()).setAllowCoreThreadTimeOut(happyWebProperties.getPool().isAllowCoreThreadTimeOut()).setKeepAliveTime(TimeUnit.MILLISECONDS.toNanos(happyWebProperties.getPool().getKeepAliveTime())).useArrayBlockingQueue(happyWebProperties.getPool().getQueueCapacity()).setHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy()).setThreadFactory(r -> {
            Thread thread = new Thread(r);
            thread.setName(String.format("happy-code-pool %s", thread.getId()));
            return thread;
        }).build();
        return TtlExecutors.getTtlExecutor((Executor)executorService);
    }
}

