/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.web.exception;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cool.happycoding.code.base.common.HappyStatus;
import cool.happycoding.code.base.common.ResultCode;
import cool.happycoding.code.base.exception.BizException;
import cool.happycoding.code.base.result.Result;
import cool.happycoding.code.web.exception.ErrorDetail;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result handleConstraintViolationException(ConstraintViolationException ex, HttpServletRequest request) {
        String path = request.getRequestURI();
        Map<String, Object> error = ex.getConstraintViolations().stream().collect(Collectors.groupingBy(cv -> cv.getPropertyPath().toString())).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.constraint((List)entry.getValue())));
        log.error("Validation error:{}", error);
        log.error("exception: ", (Throwable)ex);
        return ErrorDetail.error((ResultCode)HappyStatus.REQUEST_VALIDATION_FAILED, path, error);
    }

    private String constraint(List<ConstraintViolation<?>> errorList) {
        if (CollUtil.isEmpty(errorList)) {
            return "\u65e0\u9519\u8bef\u63d0\u793a";
        }
        return errorList.stream().map(fieldError -> {
            String message = fieldError.getMessage();
            return StrUtil.isEmpty((CharSequence)message) ? "\u65e0\u9519\u8bef\u63d0\u793a" : message;
        }).collect(Collectors.joining("\uff1b"));
    }

    @ResponseBody
    @ExceptionHandler(value={BizException.class})
    public Result handleAppException(BizException ex, HttpServletRequest request) {
        log.error("exception:", (Throwable)ex);
        return ErrorDetail.error(ex.getErrCode(), ex.getErrMessage(), request.getRequestURI());
    }

    @ResponseBody
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result handleInvalidRequest(MethodArgumentNotValidException ex, HttpServletRequest request) {
        String path = request.getRequestURI();
        Map<String, Object> error = ex.getBindingResult().getFieldErrors().stream().collect(Collectors.groupingBy(FieldError::getField)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.validMessage((List)entry.getValue())));
        log.error("Validation error for [{}]: {}", (Object)ex.getParameter().getParameterType().getName(), error);
        log.error("exception:", (Throwable)ex);
        return ErrorDetail.error((ResultCode)HappyStatus.REQUEST_VALIDATION_FAILED, path, error);
    }

    private String validMessage(List<FieldError> errorList) {
        if (CollUtil.isEmpty(errorList)) {
            return "\u65e0\u9519\u8bef\u63d0\u793a";
        }
        return errorList.stream().map(fieldError -> {
            String message = fieldError.getDefaultMessage();
            return StrUtil.isEmpty((CharSequence)message) ? "\u65e0\u9519\u8bef\u63d0\u793a" : message;
        }).collect(Collectors.joining("\uff1b"));
    }

    @ResponseBody
    @ExceptionHandler(value={Throwable.class})
    public Result handleGeneralException(Throwable ex, HttpServletRequest request) {
        String path = request.getRequestURI();
        log.error("exception: ", ex);
        return ErrorDetail.error((ResultCode)HappyStatus.INTERNAL_SYSTEM_ERROR, path);
    }
}

