/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.web.exception;

import cn.hutool.core.util.StrUtil;
import com.google.common.collect.ImmutableMap;
import cool.happycoding.code.base.exception.BizException;
import cool.happycoding.code.base.result.Result;
import cool.happycoding.code.web.exception.ErrorDetail;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;

@RestController
public class HappyErrorController
extends AbstractErrorController {
    private static final Logger log = LoggerFactory.getLogger(HappyErrorController.class);
    private static final String PATH = "/error";
    private final ErrorAttributes errorAttributes;

    public HappyErrorController(ErrorAttributes errorAttributes) {
        super(errorAttributes);
        this.errorAttributes = errorAttributes;
    }

    @RequestMapping(value={"/error"}, produces={"application/json"})
    public Result handleError(HttpServletRequest request) {
        ServletWebRequest webRequest = new ServletWebRequest(request);
        Throwable throwable = this.errorAttributes.getError((WebRequest)webRequest);
        if (throwable instanceof BizException) {
            throw (BizException)throwable;
        }
        Map attributes = this.getErrorAttributes(request, ErrorAttributeOptions.defaults());
        int status = (Integer)attributes.get("status");
        String error = (String)attributes.get("error");
        String path = (String)attributes.get("path");
        return ErrorDetail.error(String.valueOf(status), error, path, (Map<String, Object>)ImmutableMap.of((Object)"detail", (Object)StrUtil.blankToDefault((CharSequence)error, (String)throwable.getMessage())));
    }

    public String getErrorPath() {
        return PATH;
    }
}

