/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.web.fastjson;

import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import cool.happycoding.code.web.HappyWebProperties;
import cool.happycoding.code.web.fastjson.deserializer.FastJsonDateDeserializer;
import cool.happycoding.code.web.fastjson.serializer.FastJsonBigDecimalAsPlainSerializer;
import cool.happycoding.code.web.fastjson.serializer.FastJsonDateSerializer;
import cool.happycoding.code.web.fastjson.serializer.FastJsonLongAsPlainSerializer;
import java.math.BigDecimal;
import java.util.Date;

public class CustomerFastJsonConfig {
    private final HappyWebProperties happyWebProperties;

    public CustomerFastJsonConfig(HappyWebProperties happyWebProperties) {
        this.happyWebProperties = happyWebProperties;
    }

    public FastJsonConfig fastJsonConfig() {
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setDateFormat(this.happyWebProperties.getSerializer().getDateFormat());
        fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteEnumUsingToString, SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat});
        if (this.happyWebProperties.getDeserializer().isEnableDate()) {
            fastJsonConfig.getParserConfig().putDeserializer(Date.class, (ObjectDeserializer)new FastJsonDateDeserializer());
        }
        if (this.happyWebProperties.getSerializer().isEnableDate()) {
            fastJsonConfig.getSerializeConfig().put(Date.class, (ObjectSerializer)new FastJsonDateSerializer(this.happyWebProperties.getSerializer().getDateFormat()));
        }
        if (this.happyWebProperties.getSerializer().isEnableBigDecimalAsPlain()) {
            fastJsonConfig.getSerializeConfig().put(BigDecimal.class, (ObjectSerializer)new FastJsonBigDecimalAsPlainSerializer());
        }
        if (this.happyWebProperties.getSerializer().isEnableLongAsPlain()) {
            fastJsonConfig.getSerializeConfig().put(Long.class, (ObjectSerializer)new FastJsonLongAsPlainSerializer());
        }
        return fastJsonConfig;
    }
}

