/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.web.jackson2;

import cn.hutool.core.collection.CollUtil;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.google.common.collect.Lists;
import cool.happycoding.code.web.HappyWebProperties;
import cool.happycoding.code.web.jackson2.deserializer.Jackson2DateDeserializer;
import cool.happycoding.code.web.jackson2.deserializer.Jackson2LocalDateTimeDeserializer;
import cool.happycoding.code.web.jackson2.serializer.Jackson2BigDecimalAsPlainSerializer;
import cool.happycoding.code.web.jackson2.serializer.Jackson2DateSerializer;
import cool.happycoding.code.web.jackson2.serializer.Jackson2LocalDateTimeSerializer;
import cool.happycoding.code.web.jackson2.serializer.Jackson2LongAsPlainSerializer;
import java.util.List;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class CustomerJackson2Config
implements Jackson2ObjectMapperBuilderCustomizer {
    private final HappyWebProperties happyWebProperties;
    private List<JsonDeserializer<?>> jsonDeserializers = Lists.newArrayList();
    private List<JsonSerializer<?>> jsonSerializers = Lists.newArrayList();

    public CustomerJackson2Config(HappyWebProperties happyWebProperties) {
        this.happyWebProperties = happyWebProperties;
    }

    public void customize(Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder) {
        if (this.happyWebProperties.getDeserializer().isEnableDate()) {
            this.jsonDeserializers.add(new Jackson2DateDeserializer());
            this.jsonDeserializers.add(new Jackson2LocalDateTimeDeserializer());
        }
        if (this.happyWebProperties.getSerializer().isEnableDate()) {
            this.jsonSerializers.add(new Jackson2DateSerializer(this.happyWebProperties.getSerializer().getDateFormat()));
            this.jsonSerializers.add(new Jackson2LocalDateTimeSerializer(this.happyWebProperties.getSerializer().getDateFormat()));
        }
        if (this.happyWebProperties.getSerializer().isEnableBigDecimalAsPlain()) {
            this.jsonSerializers.add(new Jackson2BigDecimalAsPlainSerializer());
        }
        if (this.happyWebProperties.getSerializer().isEnableLongAsPlain()) {
            this.jsonSerializers.add(new Jackson2LongAsPlainSerializer());
        }
        if (CollUtil.isNotEmpty(this.jsonDeserializers)) {
            jacksonObjectMapperBuilder.deserializers(this.jsonDeserializers.toArray(new JsonDeserializer[0]));
        }
        if (CollUtil.isNotEmpty(this.jsonSerializers)) {
            jacksonObjectMapperBuilder.serializers(this.jsonSerializers.toArray(new JsonSerializer[0]));
        }
    }

    public void setJsonDeserializers(List<JsonDeserializer<?>> jsonDeserializers) {
        this.jsonDeserializers = jsonDeserializers;
    }

    public void setJsonSerializers(List<JsonSerializer<?>> jsonSerializers) {
        this.jsonSerializers = jsonSerializers;
    }

    public HappyWebProperties getHappyWebProperties() {
        return this.happyWebProperties;
    }

    public List<JsonDeserializer<?>> getJsonDeserializers() {
        return this.jsonDeserializers;
    }

    public List<JsonSerializer<?>> getJsonSerializers() {
        return this.jsonSerializers;
    }
}

