/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.web.jackson2.deserializer;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.util.ClassUtil;
import cool.happycoding.code.base.util.DateUtils;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;

public class Jackson2LocalDateTimeDeserializer
extends JsonDeserializer<LocalDateTime> {
    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String pattern;
        String localDateTime;
        JsonToken token = jsonParser.getCurrentToken();
        if (token == JsonToken.VALUE_STRING && StrUtil.isNotBlank((CharSequence)(localDateTime = jsonParser.getText().trim())) && StrUtil.isNotBlank((CharSequence)(pattern = DateUtils.datePattern((String)localDateTime)))) {
            return LocalDateTimeUtil.parse((CharSequence)localDateTime, (String)pattern);
        }
        if (token == JsonToken.VALUE_NUMBER_INT) {
            return new Timestamp(jsonParser.getLongValue()).toLocalDateTime();
        }
        throw JsonMappingException.from((JsonParser)jsonParser, (String)String.format("Cannot deserialize instance of %s out of %s token", ClassUtil.nameOf(this.handledType()), token));
    }

    public Class<?> handledType() {
        return LocalDateTime.class;
    }
}

