/*
 * Decompiled with CFR 0.152.
 */
package cool.happycoding.code.web.jackson2.serializer;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;

public class Jackson2LongAsPlainSerializer
extends JsonSerializer<Long> {
    private final Set<String> excludeFieldNames = Sets.newHashSet((Object[])new String[]{"current", "pages", "size"});

    public void serialize(Long value, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
        String fieldName = jsonGenerator.getOutputContext().getCurrentName();
        if (!this.excludeFieldNames.contains(StrUtil.toString((Object)fieldName))) {
            jsonGenerator.writeString(Long.toString(value));
        } else {
            jsonGenerator.writeNumber(value.longValue());
        }
    }
}

