/*
 * Decompiled with CFR 0.152.
 */
package cool.klass.generator.json.view.plugin;

import cool.klass.generator.json.view.JsonViewGenerator;
import cool.klass.generator.plugin.AbstractGenerateMojo;
import cool.klass.model.meta.domain.api.DomainModel;
import cool.klass.model.meta.domain.api.source.DomainModelWithSourceCode;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-json-views", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class GenerateJsonViewsMojo
extends AbstractGenerateMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/json-views")
    private File outputDirectory;
    @Parameter(property="applicationName", required=true)
    private String applicationName;
    @Parameter(property="rootPackageName", required=true)
    private String rootPackageName;

    public void execute() throws MojoExecutionException {
        DomainModelWithSourceCode domainModel = this.getDomainModel();
        try {
            JsonViewGenerator jsonViewGenerator = new JsonViewGenerator((DomainModel)domainModel, this.rootPackageName, this.applicationName);
            jsonViewGenerator.writeJsonViews(this.outputDirectory.toPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        String outputDirectoryPath = this.outputDirectory.getPath();
        this.getLog().info((CharSequence)("Adding compile source root: " + outputDirectoryPath));
        this.mavenProject.addCompileSourceRoot(outputDirectoryPath);
    }
}

