/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.base.repository;

import cool.lazy.cat.orm.core.base.FullAutomaticMapping;
import cool.lazy.cat.orm.core.base.bo.PageResult;
import cool.lazy.cat.orm.core.base.bo.QueryInfo;
import cool.lazy.cat.orm.core.base.util.Ignorer;
import cool.lazy.cat.orm.core.jdbc.OrderBy;
import cool.lazy.cat.orm.core.jdbc.condition.Condition;
import cool.lazy.cat.orm.core.jdbc.dto.CascadeLevelMapper;
import cool.lazy.cat.orm.core.jdbc.param.SearchParam;
import cool.lazy.cat.orm.core.jdbc.param.UpdateParam;
import java.util.Collection;
import java.util.List;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.support.KeyHolder;

public interface BaseRepository<P>
extends FullAutomaticMapping {
    public NamedParameterJdbcTemplate getJdbcTemplate();

    public <T> List<T> query(SearchParam<T> var1);

    public <T> PageResult<T> queryPage(SearchParam<T> var1);

    public List<P> selectByInfo(QueryInfo var1);

    default public P selectSingle(Condition condition) {
        return this.selectSingle(condition, Ignorer.EMPTY_IGNORE);
    }

    public P selectSingle(Condition var1, Ignorer var2);

    default public <T> T selectSingle(Class<T> pojoType, Condition condition) {
        return this.selectSingle(pojoType, condition, Ignorer.EMPTY_IGNORE);
    }

    public <T> T selectSingle(Class<T> var1, Condition var2, Ignorer var3);

    default public List<P> select(Condition condition) {
        return this.select(condition, Ignorer.EMPTY_IGNORE);
    }

    public List<P> select(Condition var1, Ignorer var2);

    default public List<P> select(Condition condition, OrderBy orderBy) {
        return this.select(condition, orderBy, Ignorer.EMPTY_IGNORE);
    }

    public List<P> select(Condition var1, OrderBy var2, Ignorer var3);

    default public <T> List<T> select(Class<T> pojoType, Condition condition) {
        return this.select(pojoType, condition, Ignorer.EMPTY_IGNORE);
    }

    public <T> List<T> select(Class<T> var1, Condition var2, Ignorer var3);

    default public <T> List<T> select(Class<T> pojoType, Condition condition, OrderBy orderBy) {
        return this.select(pojoType, condition, orderBy, Ignorer.EMPTY_IGNORE);
    }

    public <T> List<T> select(Class<T> var1, Condition var2, OrderBy var3, Ignorer var4);

    public PageResult<P> selectPage(QueryInfo var1);

    default public PageResult<P> selectPage(Condition condition, int index, int pageSize) {
        return this.selectPage(condition, index, pageSize, Ignorer.EMPTY_IGNORE);
    }

    public PageResult<P> selectPage(Condition var1, int var2, int var3, Ignorer var4);

    default public PageResult<P> selectPage(Condition condition, int index, int pageSize, OrderBy orderBy) {
        return this.selectPage(condition, index, pageSize, orderBy, Ignorer.EMPTY_IGNORE);
    }

    public PageResult<P> selectPage(Condition var1, int var2, int var3, OrderBy var4, Ignorer var5);

    default public <T> PageResult<T> selectPage(Class<T> pojoType, Condition condition, int index, int pageSize) {
        return this.selectPage(pojoType, condition, index, pageSize, Ignorer.EMPTY_IGNORE);
    }

    public <T> PageResult<T> selectPage(Class<T> var1, Condition var2, int var3, int var4, Ignorer var5);

    default public <T> PageResult<T> selectPage(Class<T> pojoType, Condition condition, int index, int pageSize, OrderBy orderBy) {
        return this.selectPage(pojoType, condition, index, pageSize, orderBy, Ignorer.EMPTY_IGNORE);
    }

    public <T> PageResult<T> selectPage(Class<T> var1, Condition var2, int var3, int var4, OrderBy var5, Ignorer var6);

    default public <T> List<T> selectByStructure(Class<T> pojoType, int cascadeLevel, Condition condition, OrderBy orderBy) {
        return this.selectByStructure(pojoType, cascadeLevel, condition, orderBy, Ignorer.EMPTY_IGNORE);
    }

    public <T> List<T> selectByStructure(Class<T> var1, int var2, Condition var3, OrderBy var4, Ignorer var5);

    default public <T> List<T> selectByStructure(Class<T> pojoType, CascadeLevelMapper cascadeLevelMapper, Condition condition, OrderBy orderBy) {
        return this.selectByStructure(pojoType, cascadeLevelMapper, condition, orderBy, Ignorer.EMPTY_IGNORE);
    }

    public <T> List<T> selectByStructure(Class<T> var1, CascadeLevelMapper var2, Condition var3, OrderBy var4, Ignorer var5);

    public int insert(P var1);

    public KeyHolder insert(P var1, KeyHolder var2);

    public int batchInsert(Collection<P> var1);

    default public int update(P pojo, Condition condition, boolean ignoreNull) {
        return this.update(pojo, condition, ignoreNull, new String[0]);
    }

    public int update(P var1, Condition var2, boolean var3, String ... var4);

    public int updateByParam(UpdateParam var1);

    public <T> int delete(Class<T> var1, Condition var2);

    public int logicDelete(P var1, Condition var2);
}

