/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.base.repository.impl;

import cool.lazy.cat.orm.core.base.bo.PageResult;
import cool.lazy.cat.orm.core.base.bo.QueryInfo;
import cool.lazy.cat.orm.core.base.repository.BaseRepository;
import cool.lazy.cat.orm.core.base.repository.impl.AbstractRepository;
import cool.lazy.cat.orm.core.base.util.Caster;
import cool.lazy.cat.orm.core.base.util.CollectionUtil;
import cool.lazy.cat.orm.core.base.util.Ignorer;
import cool.lazy.cat.orm.core.jdbc.OrderBy;
import cool.lazy.cat.orm.core.jdbc.condition.Condition;
import cool.lazy.cat.orm.core.jdbc.dto.CascadeLevelMapper;
import cool.lazy.cat.orm.core.jdbc.holder.SqlParamHolder;
import cool.lazy.cat.orm.core.jdbc.holder.TableChainHolder;
import cool.lazy.cat.orm.core.jdbc.mapping.PojoMapping;
import cool.lazy.cat.orm.core.jdbc.mapping.TableInfo;
import cool.lazy.cat.orm.core.jdbc.param.SimpleSearchParam;
import cool.lazy.cat.orm.core.jdbc.param.SimpleUpdateParam;
import cool.lazy.cat.orm.core.jdbc.param.UpdateParam;
import cool.lazy.cat.orm.core.jdbc.util.TableChainBuildHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.support.KeyHolder;

public class BaseRepositoryImpl<P>
extends AbstractRepository<P>
implements BaseRepository<P> {
    @Override
    public List<P> selectByInfo(QueryInfo queryInfo) {
        return (List)Caster.cast(super.queryByInfo(queryInfo));
    }

    @Override
    public List<P> select(Condition condition, Ignorer ignorer) {
        return this.select(condition, null, ignorer);
    }

    @Override
    public List<P> select(Condition condition, OrderBy orderBy, Ignorer ignorer) {
        return (List)Caster.cast(super.query(this.getPojoType(), condition, orderBy, ignorer));
    }

    @Override
    public P selectSingle(Condition condition, Ignorer ignorer) {
        List<P> result = this.select(condition, ignorer);
        return (P)DataAccessUtils.nullableSingleResult(result);
    }

    @Override
    public <T> List<T> select(Class<T> pojoType, Condition condition, Ignorer ignorer) {
        return this.select(pojoType, condition, null, ignorer);
    }

    @Override
    public <T> List<T> select(Class<T> pojoType, Condition condition, OrderBy orderBy, Ignorer ignorer) {
        return super.query(pojoType, condition, orderBy, ignorer);
    }

    @Override
    public <T> T selectSingle(Class<T> pojoType, Condition condition, Ignorer ignorer) {
        List<T> result = this.select(pojoType, condition, ignorer);
        return (T)DataAccessUtils.nullableSingleResult(result);
    }

    @Override
    public PageResult<P> selectPage(QueryInfo queryInfo) {
        return (PageResult)Caster.cast(super.queryPage(queryInfo));
    }

    @Override
    public PageResult<P> selectPage(Condition condition, int index, int pageSize, Ignorer ignorer) {
        return this.selectPage(condition, index, pageSize, null, ignorer);
    }

    @Override
    public PageResult<P> selectPage(Condition condition, int index, int pageSize, OrderBy orderBy, Ignorer ignorer) {
        return (PageResult)Caster.cast(super.queryPage(this.getPojoType(), condition, index, pageSize, orderBy, ignorer));
    }

    @Override
    public <T> PageResult<T> selectPage(Class<T> pojoType, Condition condition, int index, int pageSize, Ignorer ignorer) {
        return this.selectPage(pojoType, condition, index, pageSize, null, ignorer);
    }

    @Override
    public <T> PageResult<T> selectPage(Class<T> pojoType, Condition condition, int index, int pageSize, OrderBy orderBy, Ignorer ignorer) {
        return super.queryPage(pojoType, condition, index, pageSize, orderBy, ignorer);
    }

    @Override
    public <T> List<T> selectByStructure(Class<T> pojoType, int cascadeLevel, Condition condition, OrderBy orderBy, Ignorer ignorer) {
        return this.selectByStructure(pojoType, CascadeLevelMapper.buildAll(cascadeLevel), condition, orderBy, ignorer);
    }

    @Override
    public <T> List<T> selectByStructure(Class<T> pojoType, CascadeLevelMapper cascadeLevelMapper, Condition condition, OrderBy orderBy, Ignorer ignorer) {
        List<PojoMapping> mappings;
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(pojoType).getTableInfo();
        TableChainHolder holder = TableChainBuildHelper.build(tableInfo, mappings = CollectionUtil.concat(tableInfo.getOneToOneMapping(), tableInfo.getOneToManyMapping(), tableInfo.getManyToOneMapping()), this.pojoTableManager.getAllSubjectMap(), cascadeLevelMapper);
        if (holder.getFlatChain().size() > 40) {
            this.logger.warn((Object)("\u7ea7\u8054\u67e5\u8be2\u8868\u5df2\u8d85\u8fc7\uff1a40\t\u8bf7\u6ce8\u610f\u5bf9\u4e0d\u9700\u8981\u7684\u5b57\u6bb5\u3001\u5bf9\u8c61\u5ffd\u7565\u67e5\u8be2#" + pojoType.getName()));
        }
        SimpleSearchParam sqlSearchParam = new SimpleSearchParam(this.pojoTableManager.getByPojoType(pojoType).getTableInfo());
        ((SimpleSearchParam)((SimpleSearchParam)((SimpleSearchParam)((SimpleSearchParam)((SimpleSearchParam)sqlSearchParam.setPojoType((Class)pojoType)).setCondition(condition == null ? Condition.EMPTY_CONDITION : condition)).setOrderBy(orderBy)).setIgnorer(ignorer)).setNestedChain((List)holder.getNestedChain())).setFlatChain((List)holder.getFlatChain());
        return super.query(sqlSearchParam);
    }

    @Override
    public int insert(P pojo) {
        SqlParamHolder holder = this.sqlParamProvider.getInsertSql(new SimpleUpdateParam().setData(pojo));
        return this.jdbcTemplate.update(holder.getSql(), holder.getParamSource());
    }

    @Override
    public KeyHolder insert(P pojo, KeyHolder keyHolder) {
        SqlParamHolder holder = this.sqlParamProvider.getInsertSql(new SimpleUpdateParam().setData(pojo));
        this.jdbcTemplate.update(holder.getSql(), holder.getParamSource(), keyHolder);
        return keyHolder;
    }

    @Override
    public int batchInsert(Collection<P> pojoList) {
        SqlParamHolder holder = this.sqlParamProvider.getInsertSql(new SimpleUpdateParam().setData(pojoList));
        int[] affectedRows = this.jdbcTemplate.batchUpdate(holder.getSql(), holder.getParamSources());
        return Arrays.stream(affectedRows).sum();
    }

    @Override
    public int update(P pojo, Condition condition, boolean ignoreNull, String ... ignoreFields) {
        return this.updateByParam(new SimpleUpdateParam(null, condition, ignoreNull, ignoreFields, pojo));
    }

    @Override
    public int updateByParam(UpdateParam updateParam) {
        SqlParamHolder holder = this.sqlParamProvider.getUpdateSql(updateParam);
        return this.jdbcTemplate.update(holder.getSql(), holder.getParamSource());
    }

    @Override
    public <T> int delete(Class<T> pojoType, Condition condition) {
        SqlParamHolder holder = this.sqlParamProvider.getDeleteSql(new SimpleUpdateParam(pojoType, condition, false, null, null));
        return this.jdbcTemplate.update(holder.getSql(), holder.getParam());
    }

    @Override
    public int logicDelete(P pojo, Condition condition) {
        SqlParamHolder holder = this.sqlParamProvider.getLogicDeleteSql(new SimpleUpdateParam(null, condition, false, null, pojo));
        return this.jdbcTemplate.update(holder.getSql(), holder.getParamSource());
    }
}

