/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.base.service.impl;

import cool.lazy.cat.orm.core.base.AbstractFullAutomaticMapping;
import cool.lazy.cat.orm.core.base.bo.QueryInfo;
import cool.lazy.cat.orm.core.base.repository.BaseRepository;
import cool.lazy.cat.orm.core.base.service.BaseService;
import cool.lazy.cat.orm.core.base.util.Caster;
import cool.lazy.cat.orm.core.base.util.InvokeHelper;
import cool.lazy.cat.orm.core.context.FullAutoMappingContext;
import cool.lazy.cat.orm.core.jdbc.DataOperationType;
import cool.lazy.cat.orm.core.jdbc.condition.Condition;
import cool.lazy.cat.orm.core.jdbc.manager.PojoTableManager;
import cool.lazy.cat.orm.core.jdbc.mapping.LogicDeleteField;
import cool.lazy.cat.orm.core.jdbc.mapping.On;
import cool.lazy.cat.orm.core.jdbc.mapping.TableChain;
import cool.lazy.cat.orm.core.jdbc.mapping.TableInfo;
import cool.lazy.cat.orm.core.jdbc.param.SearchParam;
import cool.lazy.cat.orm.core.jdbc.param.SimpleSearchParam;
import cool.lazy.cat.orm.core.manager.BusinessManager;
import cool.lazy.cat.orm.core.manager.subject.BusinessSubject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public abstract class AbstractService<P>
extends AbstractFullAutomaticMapping<P>
implements BaseService<P> {
    @Autowired
    @Lazy
    protected BusinessManager businessManager;
    @Autowired
    protected PojoTableManager pojoTableManager;
    protected final Log logger = LogFactory.getLog(this.getClass());

    protected Class<?> tryGetPojoType() {
        Class<?> pojoType = FullAutoMappingContext.getPojoType();
        return pojoType == null ? super.getPojoType() : pojoType;
    }

    private BusinessSubject getSubject(Class<?> pojoType) {
        return this.businessManager.getBusinessSubject(pojoType);
    }

    protected BaseService<?> getService(Class<?> pojoType) {
        return this.getSubject(pojoType).getServiceSubject().getService();
    }

    protected BaseRepository<?> getRepository(Class<?> pojoType) {
        return this.getSubject(pojoType).getRepositorySubject().getRepository();
    }

    protected String getPojoIdName(Object instance) {
        return this.getPojoIdName(instance.getClass());
    }

    protected String getPojoIdName(Class<?> pojoType) {
        return this.pojoTableManager.getByPojoType(pojoType).getTableInfo().getId().getJavaFieldName();
    }

    protected Object getPojoId(Object instance) {
        return InvokeHelper.invokeGetter(this.pojoTableManager.getByPojoType(instance.getClass()).getTableInfo().getId().getGetter(), instance);
    }

    protected void initCondition(QueryInfo queryInfo) {
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(this.tryGetPojoType()).getTableInfo();
        LogicDeleteField logicDeleteField = tableInfo.getLogicDeleteField();
        if (null != logicDeleteField) {
            if (queryInfo.getParams() == null) {
                queryInfo.setParams(Collections.singletonMap(logicDeleteField.getJavaFieldName(), logicDeleteField.getNormalValue()));
            } else {
                Map<String, Object> params = queryInfo.getParams();
                if (!params.containsKey(logicDeleteField.getJavaFieldName())) {
                    params.put(logicDeleteField.getJavaFieldName(), logicDeleteField.getNormalValue());
                }
            }
        }
    }

    protected Condition initCondition(Class<?> pojoType) {
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(pojoType).getTableInfo();
        if (null != tableInfo.getLogicDeleteField()) {
            LogicDeleteField logicDeleteField = tableInfo.getLogicDeleteField();
            return Condition.eq(logicDeleteField.getJavaFieldName(), logicDeleteField.getNormalValue());
        }
        return null;
    }

    @Override
    public <T> SearchParam<T> buildSearchParam(Class<T> pojoType) {
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(pojoType).getTableInfo();
        SearchParam searchParam = new SimpleSearchParam(tableInfo).setPojoType((Class)pojoType);
        Condition condition = this.initCondition(pojoType);
        ((SimpleSearchParam)searchParam).setCondition(condition == null ? Condition.EMPTY_CONDITION : condition);
        return searchParam;
    }

    protected void dataOperation(DataOperationType type, Object src, boolean cascade) {
        TableInfo tableInfo;
        if (cascade && (tableInfo = this.pojoTableManager.getByPojoType(src.getClass()).getTableInfo()).isNested()) {
            this.dataOperation(type, tableInfo, tableInfo.getNestedChain(), src, cascade);
        }
    }

    protected void dataOperation(DataOperationType type, TableInfo tableInfo, List<TableChain> nestedChainList, Object src, boolean cascade) {
        if (cascade && tableInfo.isNested()) {
            this.recursionUpdate(type, src, nestedChainList);
        }
    }

    private void recursionUpdate(DataOperationType type, Object src, List<TableChain> nestedChainList) {
        for (TableChain chain : nestedChainList) {
            Object newSrc = InvokeHelper.invokeGetter(chain.getBelongField().getGetter(), src);
            if (null == newSrc) continue;
            if (newSrc instanceof Collection) {
                for (Object o : (Collection)newSrc) {
                    this.updateSingleObj(src, chain, o, type);
                }
            } else {
                this.updateSingleObj(src, chain, newSrc, type);
            }
            if (!chain.hasChain()) continue;
            if (newSrc instanceof Collection) {
                for (Object o : (Collection)newSrc) {
                    this.recursionUpdate(type, o, chain.getChain());
                }
                continue;
            }
            this.recursionUpdate(type, newSrc, chain.getChain());
        }
    }

    private void updateSingleObj(Object src, TableChain chain, Object instance, DataOperationType type) {
        if (type == DataOperationType.DELETE) {
            if (chain.getPojoMapping().isDeletable()) {
                this.getService(instance.getClass()).delete(Caster.cast(instance), false);
            }
        } else if (type == DataOperationType.LOGIC_DELETE) {
            if (chain.getPojoMapping().isDeletable()) {
                this.getService(instance.getClass()).logicDelete(Caster.cast(instance), false);
            }
        } else {
            this.beforeCascadeUpdate(src, instance, chain);
            if (null == this.getPojoId(instance)) {
                if (chain.getPojoMapping().isInsertable()) {
                    this.getService(instance.getClass()).insert(Caster.cast(instance), false);
                }
            } else if (chain.getPojoMapping().isUpdatable()) {
                this.getService(instance.getClass()).update(Caster.cast(instance), false);
            }
        }
    }

    private void beforeCascadeUpdate(Object src, Object instance, TableChain chain) {
        List<On> chainJoinCondition = chain.getJoinCondition();
        for (On on : chainJoinCondition) {
            Object foreignVal = InvokeHelper.invokeGetter(on.getForeignKeyInfo().getGetter(), src);
            InvokeHelper.invokeSetter(on.getTargetFiledInfo().getSetter(), instance, foreignVal);
        }
    }
}

