/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.base.service.impl;

import cool.lazy.cat.orm.core.base.bo.PageResult;
import cool.lazy.cat.orm.core.base.bo.QueryInfo;
import cool.lazy.cat.orm.core.base.service.BaseService;
import cool.lazy.cat.orm.core.base.service.impl.AbstractService;
import cool.lazy.cat.orm.core.base.util.BeanFieldUtil;
import cool.lazy.cat.orm.core.base.util.Caster;
import cool.lazy.cat.orm.core.base.util.CollectionUtil;
import cool.lazy.cat.orm.core.base.util.InvokeHelper;
import cool.lazy.cat.orm.core.jdbc.DataOperationType;
import cool.lazy.cat.orm.core.jdbc.component.id.Auto;
import cool.lazy.cat.orm.core.jdbc.component.id.IdGenerator;
import cool.lazy.cat.orm.core.jdbc.condition.Condition;
import cool.lazy.cat.orm.core.jdbc.mapping.IdStrategy;
import cool.lazy.cat.orm.core.jdbc.mapping.LogicDeleteField;
import cool.lazy.cat.orm.core.jdbc.mapping.TableInfo;
import cool.lazy.cat.orm.core.jdbc.param.SearchParam;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BaseServiceImpl<P>
extends AbstractService<P>
implements BaseService<P> {
    @Override
    public Collection<P> selectByParam(SearchParam<P> searchParam) {
        return this.selectByParam((Class)Caster.cast(this.tryGetPojoType()), searchParam);
    }

    @Override
    public <T> Collection<T> selectByParam(Class<T> pojoType, SearchParam<T> searchParam) {
        return super.getRepository(pojoType).query(searchParam);
    }

    @Override
    public PageResult<P> selectPageByParam(SearchParam<P> searchParam) {
        return this.selectPageByParam((Class)Caster.cast(this.tryGetPojoType()), searchParam);
    }

    @Override
    public <T> PageResult<T> selectPageByParam(Class<T> pojoType, SearchParam<T> searchParam) {
        return super.getRepository(pojoType).queryPage(searchParam);
    }

    @Override
    public Collection<P> select(QueryInfo queryInfo) {
        super.initCondition(queryInfo);
        return super.getRepository(this.tryGetPojoType()).selectByInfo(queryInfo);
    }

    @Override
    public PageResult<P> selectPage(QueryInfo queryInfo) {
        super.initCondition(queryInfo);
        return super.getRepository(this.tryGetPojoType()).selectPage(queryInfo);
    }

    @Override
    public P selectById(Object id) {
        return (P)this.selectById(this.tryGetPojoType(), id);
    }

    @Override
    public <T> T selectById(Class<T> pojoType, Object id) {
        return super.getRepository(pojoType).selectSingle(pojoType, Condition.eq(super.getPojoIdName(pojoType), id));
    }

    @Override
    public Collection<P> selectByIds(List<Object> ids) {
        return this.selectByIds(this.tryGetPojoType(), ids);
    }

    @Override
    public <T> Collection<T> selectByIds(Class<T> pojoType, List<Object> ids) {
        return super.getRepository(pojoType).select(pojoType, Condition.in(super.getPojoIdName(pojoType), ids));
    }

    @Override
    public P save(P pojo, boolean cascade) {
        if (null == super.getPojoId(pojo)) {
            return this.insert(pojo, cascade);
        }
        return this.update(pojo, cascade, false);
    }

    @Override
    public Collection<P> batchSave(Collection<P> pojoCollection, boolean cascade) {
        List addData = pojoCollection.stream().filter(p -> null == super.getPojoId(p)).collect(Collectors.toList());
        List modifyData = pojoCollection.stream().filter(p -> null != super.getPojoId(p)).collect(Collectors.toList());
        this.batchInsert(addData, cascade);
        this.batchUpdate(modifyData, cascade, false);
        addData.addAll(modifyData);
        return addData;
    }

    @Override
    public P insert(P pojo, boolean cascade) {
        IdStrategy id = this.pojoTableManager.getByPojoType(pojo.getClass()).getTableInfo().getId();
        Class<? extends IdGenerator> idGenerator = id.getIdGenerator();
        if (idGenerator == Auto.class) {
            GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
            super.getRepository(pojo.getClass()).insert(Caster.cast(pojo), (KeyHolder)keyHolder);
            InvokeHelper.invokeSetter(id.getSetter(), pojo, BeanFieldUtil.typeAdapter(id.getJavaType(), keyHolder.getKey()));
        } else {
            super.getRepository(pojo.getClass()).insert(Caster.cast(pojo));
        }
        super.dataOperation(DataOperationType.INSERT, pojo, cascade);
        return pojo;
    }

    @Override
    public Collection<P> batchInsert(Collection<P> pojoCollection, boolean cascade) {
        Class<?> pojoType = BeanFieldUtil.getTypeFromObj(pojoCollection);
        super.getRepository(pojoType).batchInsert((Collection)Caster.cast(pojoCollection));
        if (cascade) {
            pojoCollection.forEach(p -> super.dataOperation(DataOperationType.INSERT, p, true));
        }
        return pojoCollection;
    }

    @Override
    public P update(P pojo, boolean cascade, boolean ignoreNull) {
        super.getRepository(pojo.getClass()).update(Caster.cast(pojo), Condition.eq(super.getPojoIdName(pojo), super.getPojoId(pojo)), ignoreNull);
        super.dataOperation(DataOperationType.UPDATE, pojo, cascade);
        return pojo;
    }

    @Override
    public Collection<P> batchUpdate(Collection<P> pojoCollection, boolean cascade, boolean ignoreNull) {
        pojoCollection.forEach(p -> this.update(p, cascade, ignoreNull));
        return pojoCollection;
    }

    @Override
    public void delete(P pojo, boolean cascade) {
        if (null == super.getPojoId(pojo)) {
            return;
        }
        super.getRepository(pojo.getClass()).delete(pojo.getClass(), Condition.eq(super.getPojoIdName(pojo), super.getPojoId(pojo)));
        super.dataOperation(DataOperationType.DELETE, pojo, cascade);
    }

    @Override
    public void batchDelete(Collection<P> pojoCollection, boolean cascade) {
        if (CollectionUtil.isNotEmpty(pojoCollection)) {
            Class<?> pojoType = BeanFieldUtil.getTypeFromObj(pojoCollection);
            TableInfo tableInfo = this.pojoTableManager.getByPojoType(pojoType).getTableInfo();
            IdStrategy id = tableInfo.getId();
            List ids = pojoCollection.stream().filter(Objects::nonNull).map(p -> InvokeHelper.invokeGetter(id.getGetter(), p)).filter(Objects::nonNull).collect(Collectors.toList());
            super.getRepository(pojoType).delete(pojoType, Condition.in(id.getJavaFieldName(), ids));
            if (cascade) {
                pojoCollection.forEach(p -> super.dataOperation(DataOperationType.DELETE, p, cascade));
            }
        }
    }

    @Override
    public void logicDelete(P pojo, boolean cascade) {
        Object id = super.getPojoId(pojo);
        if (null == id) {
            return;
        }
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(pojo.getClass()).getTableInfo();
        LogicDeleteField logicDeleteField = tableInfo.getLogicDeleteField();
        if (null != logicDeleteField) {
            super.getRepository(pojo.getClass()).logicDelete(Caster.cast(pojo), Condition.eq(super.getPojoIdName(pojo), super.getPojoId(pojo)));
            super.dataOperation(DataOperationType.LOGIC_DELETE, pojo, cascade);
        }
    }

    @Override
    public void batchLogicDelete(Collection<P> pojoCollection, boolean cascade) {
        pojoCollection.forEach(p -> this.logicDelete(p, cascade));
    }

    @Override
    public void deleteByInfer(P pojo, boolean cascade) {
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(pojo.getClass()).getTableInfo();
        if (null != tableInfo.getLogicDeleteField()) {
            this.logicDelete(pojo, cascade);
        } else {
            this.delete(pojo, cascade);
        }
    }

    @Override
    public void batchDeleteByInfer(Collection<P> pojoCollection, boolean cascade) {
        if (CollectionUtil.isNotEmpty(pojoCollection)) {
            TableInfo tableInfo = this.pojoTableManager.getByPojoType(BeanFieldUtil.getTypeFromObj(pojoCollection)).getTableInfo();
            if (null != tableInfo.getLogicDeleteField()) {
                this.batchLogicDelete(pojoCollection, cascade);
            } else {
                this.batchDelete(pojoCollection, cascade);
            }
        }
    }

    @Override
    public <T> void deleteByIds(Class<T> pojoType, Collection<?> ids) {
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(pojoType).getTableInfo();
        IdStrategy id = tableInfo.getId();
        super.getRepository(pojoType).getJdbcTemplate().update("delete from " + tableInfo.getFullName() + " where " + id.getDbFieldName() + " in (:ids)", Collections.singletonMap("ids", ids));
    }

    @Override
    public <T> void deleteByIdsAndInfer(Class<T> pojoType, Collection<?> ids) {
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(pojoType).getTableInfo();
        LogicDeleteField logicDeleteField = tableInfo.getLogicDeleteField();
        if (null == logicDeleteField) {
            this.deleteByIds(pojoType, ids);
        } else {
            IdStrategy id = tableInfo.getId();
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("ids", ids);
            param.put("deleteValue", logicDeleteField.getDeleteValue());
            super.getRepository(pojoType).getJdbcTemplate().update("update " + tableInfo.getFullName() + " set " + logicDeleteField.getDbFieldName() + " =:deleteValue where " + id.getDbFieldName() + " in (:ids)", param);
        }
    }
}

