/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.base.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Collection;

public final class BeanFieldUtil {
    private BeanFieldUtil() {
    }

    public static boolean isBelonged(String objName, String fieldName) {
        return null != objName && null != fieldName && fieldName.startsWith(objName) && fieldName.lastIndexOf(".") == objName.length();
    }

    public static Class<?> getTypeFromObj(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).iterator().next().getClass();
        }
        if (obj.getClass().isArray()) {
            return ((Object[])obj)[0].getClass();
        }
        return obj.getClass();
    }

    public static Object typeAdapter(Class<?> targetType, Object value) {
        if (null == value || value.getClass() == targetType) {
            return value;
        }
        if (targetType == String.class) {
            return value.toString();
        }
        if (targetType == BigInteger.class) {
            return BigInteger.valueOf(Long.parseLong(value.toString()));
        }
        if (targetType == BigDecimal.class) {
            return BigDecimal.valueOf(Long.parseLong(value.toString()));
        }
        if (Long.TYPE == targetType || targetType == Long.class) {
            return Long.parseLong(value.toString());
        }
        if (Integer.TYPE == targetType || targetType == Integer.class) {
            return Integer.valueOf(value.toString());
        }
        if (Double.TYPE == targetType || targetType == Double.class) {
            return Double.valueOf(value.toString());
        }
        if (Float.TYPE == targetType || targetType == Float.class) {
            return Float.valueOf(value.toString());
        }
        if (Boolean.TYPE == targetType || targetType == Boolean.class) {
            return Boolean.valueOf(value.toString());
        }
        if (Short.TYPE == targetType || targetType == Short.class) {
            return Short.valueOf(value.toString());
        }
        if (Byte.TYPE == targetType || targetType == Byte.class) {
            return Byte.valueOf(value.toString());
        }
        if (Character.TYPE == targetType || targetType == Character.class) {
            return value.toString().isEmpty() ? null : Character.valueOf(value.toString().charAt(0));
        }
        if (targetType == java.util.Date.class) {
            return BeanFieldUtil.convertToDate(value);
        }
        if (targetType == Date.class) {
            return BeanFieldUtil.convertToSqlDate(value);
        }
        if (targetType == LocalDate.class) {
            return BeanFieldUtil.convertToLocalDate(value);
        }
        if (targetType == LocalDateTime.class) {
            return BeanFieldUtil.convertToLocalDateTime(value);
        }
        if (targetType == LocalTime.class) {
            return BeanFieldUtil.convertToLocalTime(value);
        }
        if (targetType == Time.class) {
            return BeanFieldUtil.convertToTime(value);
        }
        if (targetType == Timestamp.class) {
            return BeanFieldUtil.convertToTimestamp(value);
        }
        throw BeanFieldUtil.error(targetType, value.getClass());
    }

    public static java.util.Date convertToDate(Object value) {
        if (value instanceof String) {
            return BeanFieldUtil.parseDate(value.toString());
        }
        if (value instanceof Long) {
            return java.util.Date.from(Instant.ofEpochMilli((Long)value));
        }
        if (value instanceof Date) {
            return new java.util.Date(((Date)value).getTime());
        }
        if (value instanceof Timestamp) {
            return new java.util.Date(((Timestamp)value).getTime());
        }
        if (value instanceof Time) {
            return new java.util.Date(((Time)value).getTime());
        }
        if (value instanceof LocalDate) {
            return java.util.Date.from(((LocalDate)value).atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
        if (value instanceof LocalDateTime) {
            return java.util.Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
        }
        if (value instanceof LocalTime) {
            return java.util.Date.from(LocalDateTime.now().withHour(((LocalTime)value).getHour()).withMinute(((LocalTime)value).getMinute()).withSecond(((LocalTime)value).getSecond()).withNano(((LocalTime)value).getNano()).atZone(ZoneId.systemDefault()).toInstant());
        }
        throw BeanFieldUtil.error(java.util.Date.class, value.getClass());
    }

    private static java.util.Date parseDate(String str) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date convertToSqlDate(Object value) {
        if (value instanceof String) {
            return Date.valueOf(value.toString());
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalDate) {
            return Date.valueOf((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return Date.valueOf(((LocalDateTime)value).toLocalDate());
        }
        throw BeanFieldUtil.error(Date.class, value.getClass());
    }

    public static LocalDate convertToLocalDate(Object value) {
        if (value instanceof String) {
            return LocalDate.parse(value.toString());
        }
        if (value instanceof Long) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)value), ZoneId.systemDefault()).toLocalDate();
        }
        if (value instanceof java.util.Date) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(((java.util.Date)value).getTime()), ZoneId.systemDefault()).toLocalDate();
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        throw BeanFieldUtil.error(LocalDate.class, value.getClass());
    }

    public static LocalDateTime convertToLocalDateTime(Object value) {
        if (value instanceof String) {
            return LocalDateTime.parse(value.toString());
        }
        if (value instanceof Long) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)value), ZoneId.systemDefault());
        }
        if (value instanceof java.util.Date) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(((java.util.Date)value).getTime()), ZoneId.systemDefault());
        }
        if (value instanceof LocalDate) {
            return ((LocalDate)value).atStartOfDay();
        }
        if (value instanceof LocalTime) {
            return LocalDateTime.now().withHour(((LocalTime)value).getHour()).withMinute(((LocalTime)value).getMinute()).withSecond(((LocalTime)value).getSecond()).withNano(((LocalTime)value).getNano());
        }
        throw BeanFieldUtil.error(LocalDateTime.class, value.getClass());
    }

    public static LocalTime convertToLocalTime(Object value) {
        if (value instanceof String) {
            return LocalTime.parse(value.toString());
        }
        if (value instanceof Long) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli((Long)value), ZoneId.systemDefault()).toLocalTime();
        }
        if (value instanceof java.util.Date) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(((java.util.Date)value).getTime()), ZoneId.systemDefault()).toLocalTime();
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalTime();
        }
        throw BeanFieldUtil.error(LocalTime.class, value.getClass());
    }

    public static Time convertToTime(Object value) {
        if (value instanceof String) {
            return Time.valueOf(value.toString());
        }
        if (value instanceof Long) {
            return new Time((Long)value);
        }
        if (value instanceof java.util.Date) {
            return new Time(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalTime) {
            return Time.valueOf((LocalTime)value);
        }
        if (value instanceof LocalDateTime) {
            return Time.valueOf(((LocalDateTime)value).toLocalTime());
        }
        throw BeanFieldUtil.error(Time.class, value.getClass());
    }

    public static Timestamp convertToTimestamp(Object value) {
        if (value instanceof String) {
            return Timestamp.valueOf(value.toString());
        }
        if (value instanceof Long) {
            return new Timestamp((Long)value);
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalDate) {
            return new Timestamp(((LocalDate)value).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        }
        if (value instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)value);
        }
        if (value instanceof LocalTime) {
            return Timestamp.valueOf(LocalDateTime.now().withHour(((LocalTime)value).getHour()).withMinute(((LocalTime)value).getMinute()).withSecond(((LocalTime)value).getSecond()).withNano(((LocalTime)value).getNano()));
        }
        throw BeanFieldUtil.error(Timestamp.class, value.getClass());
    }

    private static RuntimeException error(Class<?> targetType, Class<?> instanceType) {
        return new UnsupportedOperationException("\u65e0\u6cd5\u5904\u7406\u7684\u7c7b\u578b\u8f6c\u6362\uff1a\u76ee\u6807\u7c7b\uff1a" + targetType.getName() + "\uff0c\u5b9e\u4f8b\uff1a" + instanceType.getName());
    }
}

