/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc;

import cool.lazy.cat.orm.core.base.util.StringUtil;
import cool.lazy.cat.orm.core.jdbc.JdbcConfig;
import org.springframework.beans.factory.annotation.Autowired;

public class KeyWordConverter {
    protected boolean uppercase;

    @Autowired
    private void initUppercase(JdbcConfig jdbcConfig) {
        this.uppercase = jdbcConfig.isUppercase();
    }

    public String toDbWord(String word) {
        return StringUtil.camel2Underline(word, !this.uppercase);
    }

    public String toJavaWord(String word) {
        return StringUtil.underline2Camel(word, true);
    }

    public String call() {
        return this.uppercase ? "CALL " : "CALL ".toLowerCase();
    }

    public String select() {
        return this.uppercase ? "SELECT " : "SELECT ".toLowerCase();
    }

    public String delete() {
        return this.uppercase ? "DELETE " : "DELETE ".toLowerCase();
    }

    public String update() {
        return this.uppercase ? "UPDATE " : "UPDATE ".toLowerCase();
    }

    public String inert() {
        return this.uppercase ? "INSERT INTO " : "INSERT INTO ".toLowerCase();
    }

    public String from() {
        return this.uppercase ? "FROM " : "FROM ".toLowerCase();
    }

    public String where() {
        return this.uppercase ? "WHERE " : "WHERE ".toLowerCase();
    }

    public String and() {
        return this.uppercase ? "AND " : "AND ".toLowerCase();
    }

    public String or() {
        return this.uppercase ? "OR " : "OR ".toLowerCase();
    }

    public String on() {
        return this.uppercase ? "ON " : "ON ".toLowerCase();
    }

    public String left() {
        return this.uppercase ? "LEFT " : "LEFT ".toLowerCase();
    }

    public String right() {
        return this.uppercase ? "RIGHT " : "RIGHT ".toLowerCase();
    }

    public String join() {
        return this.uppercase ? "JOIN " : "JOIN ".toLowerCase();
    }

    public String order() {
        return this.uppercase ? "ORDER " : "ORDER ".toLowerCase();
    }

    public String by() {
        return this.uppercase ? "BY " : "BY ".toLowerCase();
    }

    public String group() {
        return this.uppercase ? "GROUP " : "GROUP ".toLowerCase();
    }

    public String count() {
        return this.uppercase ? "COUNT" : "COUNT".toLowerCase();
    }

    public String set() {
        return this.uppercase ? "SET " : "SET ".toLowerCase();
    }

    public String as() {
        return this.uppercase ? "AS " : "AS ".toLowerCase();
    }

    public String like() {
        return this.uppercase ? "LIKE " : "LIKE ".toLowerCase();
    }

    public String in() {
        return this.uppercase ? "IN " : "IN ".toLowerCase();
    }

    public String is() {
        return this.uppercase ? "IS " : "IS ".toLowerCase();
    }

    public String not() {
        return this.uppercase ? "NOT " : "NOT ".toLowerCase();
    }

    public String nul() {
        return this.uppercase ? "NULL " : "NULL ".toLowerCase();
    }

    public String limit() {
        return this.uppercase ? "LIMIT " : "LIMIT ".toLowerCase();
    }

    public String asc() {
        return this.uppercase ? "ASC " : "ASC ".toLowerCase();
    }

    public String desc() {
        return this.uppercase ? "DESC " : "DESC ".toLowerCase();
    }

    public String insert() {
        return this.uppercase ? "INSERT " : "INSERT ".toLowerCase();
    }

    public String into() {
        return this.uppercase ? "INTO " : "INTO ".toLowerCase();
    }

    public String value() {
        return this.uppercase ? "VALUE " : "VALUE ".toLowerCase();
    }

    public String values() {
        return this.uppercase ? "VALUES " : "VALUES ".toLowerCase();
    }
}

