/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.analyzer;

import cool.lazy.cat.orm.core.base.util.CollectionUtil;
import cool.lazy.cat.orm.core.base.util.Ignorer;
import cool.lazy.cat.orm.core.base.util.StringUtil;
import cool.lazy.cat.orm.core.jdbc.KeyWordConverter;
import cool.lazy.cat.orm.core.jdbc.analyzer.ConditionAnalyzer;
import cool.lazy.cat.orm.core.jdbc.analyzer.ExpressionAdapter;
import cool.lazy.cat.orm.core.jdbc.analyzer.FieldInfoCatcher;
import cool.lazy.cat.orm.core.jdbc.condition.Condition;
import cool.lazy.cat.orm.core.jdbc.dto.TableFieldInfoWrapper;
import cool.lazy.cat.orm.core.jdbc.exception.UnKnowFiledException;
import cool.lazy.cat.orm.core.jdbc.holder.SearchSqlParamHolder;
import cool.lazy.cat.orm.core.jdbc.holder.SqlParamHolder;
import cool.lazy.cat.orm.core.jdbc.holder.UpdateSqlParamHolder;
import cool.lazy.cat.orm.core.jdbc.mapping.TableChain;
import cool.lazy.cat.orm.core.jdbc.mapping.TableFieldInfo;
import cool.lazy.cat.orm.core.jdbc.param.SearchParam;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultConditionAnalyzer
implements ConditionAnalyzer {
    @Autowired
    protected FieldInfoCatcher fieldInfoCatcher;
    @Autowired
    protected KeyWordConverter keyWordConverter;
    @Autowired
    protected ExpressionAdapter expressionAdapter;

    @Override
    public SearchSqlParamHolder analysis(SearchParam searchParam) {
        Map<String, Object> params;
        if (Condition.EMPTY_CONDITION == searchParam.getCondition() || null == searchParam.getCondition() && null == searchParam.getParams()) {
            return new SearchSqlParamHolder(new StringBuilder(), Collections.emptyMap());
        }
        StringBuilder sql = new StringBuilder();
        if (searchParam.getCondition() != null) {
            params = new HashMap<String, Object>();
            this.analysis(searchParam.getPojoType(), sql, searchParam.getNestedChain(), searchParam.getCondition(), params, true, Ignorer.getFields(searchParam.getIgnorer()), true, null);
        } else {
            params = searchParam.getParams();
            this.analysis(searchParam.getPojoType(), sql, searchParam.getNestedChain(), params, Ignorer.getFields(searchParam.getIgnorer()));
        }
        return new SearchSqlParamHolder(sql, params);
    }

    @Override
    public SqlParamHolder analysis(Class<?> pojoType, Condition condition) {
        StringBuilder where = new StringBuilder();
        UpdateSqlParamHolder holder = new UpdateSqlParamHolder(where);
        if (null != condition) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            this.analysis(pojoType, where, null, condition, param, true, null, false, this.buildHook());
            holder.setParam(param);
        }
        if (where.length() > 0) {
            where.insert(0, this.keyWordConverter.where());
        }
        return holder;
    }

    protected void analysis(Class<?> pojoType, StringBuilder sql, List<TableChain> nestedChainList, Map<String, Object> params, String[] excludeFields) {
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (StringUtil.isBlank(entry.getKey()) || null == entry.getValue() || StringUtil.isBlank(entry.getValue().toString()) || CollectionUtil.contains(excludeFields, entry.getKey())) continue;
            boolean isNested = entry.getKey().contains(".");
            String tableName = null;
            TableFieldInfo fieldInfo = null;
            if (isNested) {
                TableFieldInfoWrapper wrapper = this.fieldInfoCatcher.getNestedFiledByName(nestedChainList, entry.getKey(), false);
                if (null != wrapper && wrapper.getFieldInfo().havingQueryFilter()) {
                    tableName = wrapper.getTableChain().getAliasName();
                    fieldInfo = wrapper.getFieldInfo();
                }
            } else {
                tableName = "this_";
                fieldInfo = this.fieldInfoCatcher.getByName(pojoType, entry.getKey(), false);
            }
            if (null == fieldInfo) continue;
            sql.append(this.keyWordConverter.and()).append(tableName).append(".").append(fieldInfo.getDbFieldName()).append(" ");
            this.expressionAdapter.adapterConditionSymbol(fieldInfo.getColumn().getQueryFilterType(), sql, entry.getKey());
        }
        if (sql.length() > 0) {
            sql.replace(0, this.keyWordConverter.and().length(), "");
        }
    }

    protected void analysis(Class<?> pojoType, StringBuilder sql, List<TableChain> nestedChainList, Condition condition, Map<String, Object> params, boolean strictModel, String[] excludeFields, boolean columnAliasName, Hook hook) {
        int count;
        if (null != hook) {
            hook.call(pojoType, condition);
        }
        this.render(pojoType, sql, nestedChainList, condition, params, strictModel, excludeFields, columnAliasName);
        if (null != condition.getAnd()) {
            sql.append(this.keyWordConverter.and()).append(" ( ");
            count = 0;
            for (Condition and : condition.getAnd()) {
                if (count > 0) {
                    sql.append(this.keyWordConverter.and());
                }
                sql.append(" (");
                this.analysis(pojoType, sql, nestedChainList, and, params, strictModel, excludeFields, columnAliasName, hook);
                sql.append(") ");
                ++count;
            }
            sql.append(" ) ");
        }
        if (null != condition.getOr()) {
            sql.append(this.keyWordConverter.or()).append(" ( ");
            count = 0;
            for (Condition or : condition.getOr()) {
                if (count > 0) {
                    sql.append(this.keyWordConverter.or());
                }
                sql.append(" (");
                this.analysis(pojoType, sql, nestedChainList, or, params, strictModel, excludeFields, columnAliasName, hook);
                sql.append(") ");
                ++count;
            }
            sql.append(" ) ");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void render(Class<?> pojoType, StringBuilder sql, List<TableChain> nestedChainList, Condition condition, Map<String, Object> params, boolean strictModel, String[] excludeFields, boolean tableAliasName) {
        TableFieldInfo fieldInfo;
        String tableName;
        block9: {
            if (condition.getField().contains(".")) {
                TableFieldInfoWrapper wrapper = this.fieldInfoCatcher.getNestedFiledByName(nestedChainList, condition.getField(), false);
                if (null != wrapper) {
                    boolean contains = CollectionUtil.contains(excludeFields, wrapper.getFieldInfo().getJavaFieldName());
                    if (strictModel && contains) {
                        throw new UnKnowFiledException("\u4ece\u8868\u5bf9\u8c61\u5df2\u88ab\u5ffd\u7565\uff1a" + wrapper.getTableChain().getBelongField().getJavaFieldName());
                    }
                    if (contains) {
                        return;
                    }
                    tableName = wrapper.getTableChain().getAliasName();
                    fieldInfo = wrapper.getFieldInfo();
                    break block9;
                } else {
                    if (strictModel) {
                        throw new UnKnowFiledException("\u5d4c\u5957\u7684\u5c5e\u6027\uff0c\u4e0d\u5b58\u5728\u7684\u5b57\u6bb5\uff1a" + condition.getField() + "\t\u8bf7\u68c0\u67e5cascadeLevel");
                    }
                    return;
                }
            }
            fieldInfo = this.fieldInfoCatcher.getByName(pojoType, condition.getField(), false);
            if (null == fieldInfo) {
                if (strictModel) {
                    throw new UnKnowFiledException("pojo\u4e0d\u5b58\u5728\u8be5\u5b57\u6bb5\uff1a" + condition.getField());
                }
                return;
            }
            tableName = "this_";
        }
        if (tableAliasName) {
            sql.append(tableName).append(".");
        }
        sql.append(fieldInfo.getDbFieldName()).append(" ");
        int length = sql.length();
        String fieldName = this.paramUniqueKey(condition.getField(), length);
        this.expressionAdapter.adapterConditionSymbol(condition.getType(), sql, fieldName);
        sql.append(" ");
        params.put(fieldName, condition.getValue());
    }

    private String paramUniqueKey(String key, int len) {
        if (len != -1) {
            key = key + len + "`";
        }
        return key;
    }

    private Hook buildHook() {
        return (pojoType, condition) -> {
            boolean pojoFiledOnly = this.fieldInfoCatcher.pojoFieldOnly(pojoType, new String[]{condition.getField()});
            if (!pojoFiledOnly) {
                throw new UnsupportedOperationException("\u4fee\u6539|\u5220\u9664\u64cd\u4f5c\u53ea\u5141\u8bb8\u64cd\u4f5c\u672c\u5bf9\u8c61\u4e2d\u7684\u5c5e\u6027 #" + pojoType.getName() + "#" + condition.getField());
            }
        };
    }

    @FunctionalInterface
    static interface Hook {
        public void call(Class<?> var1, Condition var2);
    }
}

