/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.analyzer;

import cool.lazy.cat.orm.core.base.util.BeanFieldUtil;
import cool.lazy.cat.orm.core.base.util.CollectionUtil;
import cool.lazy.cat.orm.core.base.util.Ignorer;
import cool.lazy.cat.orm.core.base.util.StringUtil;
import cool.lazy.cat.orm.core.jdbc.IgnoreModel;
import cool.lazy.cat.orm.core.jdbc.analyzer.FieldInfoCatcher;
import cool.lazy.cat.orm.core.jdbc.dto.ExcludeFieldInfo;
import cool.lazy.cat.orm.core.jdbc.dto.ExcludeFieldInfoWrapper;
import cool.lazy.cat.orm.core.jdbc.dto.TableFieldInfoWrapper;
import cool.lazy.cat.orm.core.jdbc.exception.UnKnowFiledException;
import cool.lazy.cat.orm.core.jdbc.manager.PojoTableManager;
import cool.lazy.cat.orm.core.jdbc.mapping.PojoMapping;
import cool.lazy.cat.orm.core.jdbc.mapping.TableChain;
import cool.lazy.cat.orm.core.jdbc.mapping.TableFieldInfo;
import cool.lazy.cat.orm.core.jdbc.mapping.TableInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultFieldInfoCatcher
implements FieldInfoCatcher {
    @Autowired
    protected PojoTableManager pojoTableManager;

    @Override
    public TableFieldInfo getByName(Class<?> pojoType, String fieldName, boolean strictModel) {
        return this.getByName(this.pojoTableManager.getByPojoType(pojoType).getTableInfo(), fieldName, strictModel);
    }

    @Override
    public TableFieldInfo getByName(TableInfo tableInfo, String fieldName, boolean strictModel) {
        List<TableFieldInfo> fieldInfoList = tableInfo.getFieldInfoList();
        TableFieldInfo fieldInfo = fieldInfoList.stream().filter(f -> f.getJavaFieldName().equals(fieldName)).findFirst().orElse(null);
        if (null == fieldInfo && strictModel) {
            throw new UnKnowFiledException("pojo\u4e0d\u5b58\u5728\u8be5\u5b57\u6bb5\uff1a" + fieldName);
        }
        return fieldInfo;
    }

    @Override
    public TableFieldInfoWrapper getNestedFiledByName(List<TableChain> nestedChainList, String fieldName, boolean strictModel) {
        return this.getFieldByPath(nestedChainList, fieldName, strictModel);
    }

    private TableFieldInfoWrapper getFieldByPath(List<TableChain> nestedChainList, String fieldName, boolean strictModel) {
        int i = fieldName.indexOf(".");
        String curNode = i == -1 ? fieldName : fieldName.substring(0, i);
        String nextNode = i == -1 ? null : fieldName.substring(i + 1);
        for (TableChain chain : nestedChainList) {
            PojoMapping pojoMapping = chain.getPojoMapping();
            if (pojoMapping.getFieldInfo().getJavaFieldName().equals(curNode)) {
                if (!StringUtil.isNotBlank(nextNode)) continue;
                if (chain.hasChain()) {
                    return this.getFieldByPath(chain.getChain(), nextNode, strictModel);
                }
                TableFieldInfo fieldInfo = this.pojoTableManager.getByPojoType(chain.getPojoType()).getTableInfo().getFieldInfoList().stream().filter(f -> f.getJavaFieldName().equals(nextNode)).findFirst().orElse(null);
                if (null == fieldInfo && strictModel) {
                    throw new UnKnowFiledException("pojo\u4e0d\u5b58\u5728\u8be5\u5b57\u6bb5\uff1a" + fieldName);
                }
                return new TableFieldInfoWrapper(chain, fieldInfo);
            }
            if (!StringUtil.isBlank(nextNode)) continue;
            Class<?> pojoType = chain.getUpperChain() == null ? chain.getPojoType() : chain.getUpperChain().getPojoType();
            TableFieldInfo fieldInfo = this.pojoTableManager.getByPojoType(pojoType).getTableInfo().getFieldInfoList().stream().filter(f -> f.getJavaFieldName().equals(curNode)).findFirst().orElse(null);
            if (null == fieldInfo) {
                return null;
            }
            return new TableFieldInfoWrapper(chain.getUpperChain(), fieldInfo);
        }
        return null;
    }

    @Override
    public ExcludeFieldInfoWrapper filterExclude(Class<?> pojoType, List<TableChain> nestedChainList, Ignorer ignorer) {
        Object[] ignoreFields = Ignorer.getFields(ignorer);
        if (CollectionUtil.isEmpty(ignoreFields)) {
            if (null != ignorer && IgnoreModel.INCLUDE == ignorer.getIgnoreModel()) {
                HashSet<ExcludeFieldInfo> result = new HashSet<ExcludeFieldInfo>();
                this.include(null, this.pojoTableManager.getByPojoType(pojoType).getTableInfo(), new String[0], nestedChainList, result);
                return new ExcludeFieldInfoWrapper().setExcludes(result);
            }
            return new ExcludeFieldInfoWrapper().setExcludes(Collections.emptySet());
        }
        HashSet<ExcludeFieldInfo> result = new HashSet<ExcludeFieldInfo>();
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(pojoType).getTableInfo();
        if (ignorer.getIgnoreModel() == IgnoreModel.EXCLUDE) {
            tableInfo.getFieldInfoList().stream().filter(arg_0 -> DefaultFieldInfoCatcher.lambda$filterExclude$3((String[])ignoreFields, arg_0)).forEach(info -> result.add(new ExcludeFieldInfo(null, (TableFieldInfo)info)));
            this.exclude(tableInfo, (String[])ignoreFields, nestedChainList, result);
        } else if (ignorer.getIgnoreModel() == IgnoreModel.INCLUDE) {
            this.renderFilterIncludeFields(null, null, (String[])ignoreFields, tableInfo.getFieldInfoList(), result);
            this.include(null, tableInfo, (String[])ignoreFields, nestedChainList, result);
        }
        Set excludeChainNode = result.stream().filter(ExcludeFieldInfo::excludeChain).collect(Collectors.toSet());
        result.removeIf(e -> {
            for (ExcludeFieldInfo excludeNode : excludeChainNode) {
                if (!e.excludeChainField() || !e.getChain().equals(excludeNode.getChain())) continue;
                return true;
            }
            return false;
        });
        return new ExcludeFieldInfoWrapper().setExcludes(result);
    }

    private void exclude(TableInfo tableInfo, String[] ignoreFields, List<TableChain> nestedChainList, Set<ExcludeFieldInfo> result) {
        if (tableInfo.isNested()) {
            for (String excludeField : ignoreFields) {
                TableChain chainByPath;
                if (excludeField.contains(".")) {
                    TableFieldInfoWrapper infoWrapper = this.getNestedFiledByName(nestedChainList, excludeField, false);
                    if (null == infoWrapper) {
                        chainByPath = this.getChainByPath(nestedChainList, excludeField);
                        if (null == chainByPath) continue;
                        result.add(new ExcludeFieldInfo(chainByPath, null));
                        continue;
                    }
                    result.add(new ExcludeFieldInfo(infoWrapper.getTableChain(), infoWrapper.getFieldInfo()));
                    continue;
                }
                TableFieldInfo info = this.getByName(tableInfo, excludeField, false);
                if (null != info || null == (chainByPath = this.getChainByPath(nestedChainList, excludeField))) continue;
                result.add(new ExcludeFieldInfo(chainByPath, null));
            }
        }
    }

    private TableChain getChainByPath(List<TableChain> nestedChainList, String fieldName) {
        int i = fieldName.indexOf(".");
        String curNode = i == -1 ? fieldName : fieldName.substring(0, i);
        String nextNode = i == -1 ? null : fieldName.substring(i + 1);
        for (TableChain chain : nestedChainList) {
            PojoMapping pojoMapping = chain.getPojoMapping();
            if (!pojoMapping.getFieldInfo().getJavaFieldName().equals(curNode)) continue;
            if (StringUtil.isNotBlank(nextNode) && chain.hasChain()) {
                return this.getChainByPath(chain.getChain(), nextNode);
            }
            if (!StringUtil.isBlank(nextNode)) continue;
            return chain;
        }
        return null;
    }

    private void include(String path, TableInfo tableInfo, String[] ignoreFields, List<TableChain> nestedChainList, Set<ExcludeFieldInfo> result) {
        if (tableInfo.isNested()) {
            for (TableChain chain : nestedChainList) {
                String chainPath = this.assembleName(path, chain);
                if (!this.containsChain(ignoreFields, chainPath)) {
                    result.add(new ExcludeFieldInfo(chain, null));
                    continue;
                }
                this.renderFilterIncludeFields(chainPath, chain, ignoreFields, this.pojoTableManager.getByPojoType(chain.getPojoType()).getTableInfo().getFieldInfoList(), result);
                if (!chain.hasChain()) continue;
                this.include(chainPath, tableInfo, ignoreFields, chain.getChain(), result);
            }
        }
    }

    private void renderFilterIncludeFields(String path, TableChain chain, String[] ignoreFields, List<TableFieldInfo> fieldInfoList, Set<ExcludeFieldInfo> result) {
        List match = fieldInfoList.stream().filter(f -> CollectionUtil.contains(ignoreFields, this.assembleName(path, (TableFieldInfo)f))).collect(Collectors.toList());
        if (!match.isEmpty()) {
            List notMatch = fieldInfoList.stream().filter(f -> !CollectionUtil.contains(ignoreFields, this.assembleName(path, (TableFieldInfo)f))).collect(Collectors.toList());
            result.addAll(notMatch.stream().map(f -> new ExcludeFieldInfo(chain, (TableFieldInfo)f)).collect(Collectors.toList()));
        }
    }

    private String assembleName(String path, TableFieldInfo fieldInfo) {
        if (null == path) {
            return fieldInfo.getJavaFieldName();
        }
        return path + "." + fieldInfo.getJavaFieldName();
    }

    private String assembleName(String path, TableChain chain) {
        if (null == path) {
            return chain.getBelongField().getJavaFieldName();
        }
        return path + "." + chain.getBelongField().getJavaFieldName();
    }

    private boolean containsChain(String[] fields, String chainName) {
        if (!CollectionUtil.contains(fields, chainName)) {
            for (String field : fields) {
                if (!BeanFieldUtil.isBelonged(chainName, field)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean pojoFieldOnly(Class<?> pojoType, String[] fieldsName) {
        for (String name : fieldsName) {
            if (name.contains(".")) {
                return false;
            }
            this.getByName(pojoType, name, true);
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$filterExclude$3(String[] ignoreFields, TableFieldInfo f) {
        return CollectionUtil.contains(ignoreFields, f.getJavaFieldName());
    }
}

