/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.analyzer;

import cool.lazy.cat.orm.core.base.util.InvokeHelper;
import cool.lazy.cat.orm.core.base.util.StringUtil;
import cool.lazy.cat.orm.core.jdbc.JdbcConfig;
import cool.lazy.cat.orm.core.jdbc.KeyWordConverter;
import cool.lazy.cat.orm.core.jdbc.analyzer.ConditionAnalyzer;
import cool.lazy.cat.orm.core.jdbc.analyzer.FieldInfoCatcher;
import cool.lazy.cat.orm.core.jdbc.analyzer.ParameterInjector;
import cool.lazy.cat.orm.core.jdbc.component.convert.TypeConverter;
import cool.lazy.cat.orm.core.jdbc.component.id.Auto;
import cool.lazy.cat.orm.core.jdbc.component.id.None;
import cool.lazy.cat.orm.core.jdbc.component.validator.SimpleValidator;
import cool.lazy.cat.orm.core.jdbc.condition.Condition;
import cool.lazy.cat.orm.core.jdbc.dialect.DialectRegister;
import cool.lazy.cat.orm.core.jdbc.dto.TableFieldInfoWrapper;
import cool.lazy.cat.orm.core.jdbc.exception.CannotResolverConditionException;
import cool.lazy.cat.orm.core.jdbc.handle.ValidateHandler;
import cool.lazy.cat.orm.core.jdbc.holder.SqlParamHolder;
import cool.lazy.cat.orm.core.jdbc.manager.PojoTableManager;
import cool.lazy.cat.orm.core.jdbc.mapping.IdStrategy;
import cool.lazy.cat.orm.core.jdbc.mapping.LogicDeleteField;
import cool.lazy.cat.orm.core.jdbc.mapping.OneToManyMapping;
import cool.lazy.cat.orm.core.jdbc.mapping.PojoMapping;
import cool.lazy.cat.orm.core.jdbc.mapping.TableChain;
import cool.lazy.cat.orm.core.jdbc.mapping.TableFieldInfo;
import cool.lazy.cat.orm.core.jdbc.mapping.TableInfo;
import cool.lazy.cat.orm.core.jdbc.param.SearchParam;
import cool.lazy.cat.orm.core.jdbc.param.UpdateParam;
import cool.lazy.cat.orm.core.jdbc.provider.IdProvider;
import cool.lazy.cat.orm.core.jdbc.provider.TypeConverterProvider;
import cool.lazy.cat.orm.core.jdbc.sqlsource.PojoPropertySqlParameterSource;
import cool.lazy.cat.orm.core.jdbc.sqlsource.UpdateConditionSqlParameterSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultParameterInjector
implements ParameterInjector {
    @Autowired
    protected FieldInfoCatcher fieldInfoCatcher;
    @Autowired
    protected PojoTableManager pojoTableManager;
    @Autowired
    protected ConditionAnalyzer conditionAnalyzer;
    @Autowired
    protected KeyWordConverter keyWordConverter;
    @Autowired
    protected TypeConverterProvider typeConverterProvider;
    @Autowired
    protected IdProvider idProvider;
    @Autowired
    protected ValidateHandler validateHandler;
    @Autowired
    protected JdbcConfig jdbcConfig;
    @Autowired
    protected DialectRegister dialectRegister;
    protected SimpleValidator simpleValidator = new SimpleValidator();

    @Override
    public Object injectOfSelect(SearchParam searchParam, StringBuilder sql) {
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(searchParam.getPojoType()).getTableInfo();
        SqlParamHolder analysis = this.conditionAnalyzer.analysis(searchParam);
        if (analysis.getSql().length() > 0) {
            sql.append(this.keyWordConverter.where()).append(analysis.getSql());
        }
        return analysis.getParam();
    }

    private void checkPageCondition(Class<?> pojoType, Condition condition, List<TableChain> nestedChain, ExistMainTableFilterHolder holder) {
        PojoMapping pojoMapping;
        TableFieldInfo fieldInfo = this.fieldInfoCatcher.getByName(pojoType, condition.getField(), false);
        if (null != fieldInfo) {
            holder.hasMainTableFilter = true;
        }
        TableFieldInfoWrapper fieldInfoWrapper = this.fieldInfoCatcher.getNestedFiledByName(nestedChain, condition.getField(), false);
        if (holder.hasMainTableFilter && fieldInfoWrapper != null && fieldInfoWrapper.getTableChain() != null && (pojoMapping = fieldInfoWrapper.getTableChain().getPojoMapping()) instanceof OneToManyMapping) {
            throw new CannotResolverConditionException("\u5b58\u5728\u4e00\u5bf9\u591a\u6620\u5c04\uff0c\u65e0\u6cd5\u89e3\u6790\u5bf9\u4ece\u8868\u7684\u6761\u4ef6\u8fc7\u6ee4\uff0c\u5c06\u5bfc\u81f4\u5206\u9875\u5931\u6548\uff01\t" + fieldInfoWrapper.getTableChain().getPojoType().getName() + "#" + condition.getField() + "\t" + (Object)((Object)condition.getType()));
        }
        if (null != condition.getAnd()) {
            for (Condition c : condition.getAnd()) {
                this.checkPageCondition(pojoType, c, nestedChain, holder);
            }
        }
        if (null != condition.getOr()) {
            for (Condition c : condition.getOr()) {
                this.checkPageCondition(pojoType, c, nestedChain, holder);
            }
        }
    }

    private void checkPageCondition(Class<?> pojoType, Map<String, Object> params, List<TableChain> nestedChain) {
        boolean hasMainTableFilter = false;
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (StringUtil.isBlank(entry.getKey()) || null == entry.getValue() || StringUtil.isBlank(entry.getValue().toString())) continue;
            boolean isNested = entry.getKey().contains(".");
            if (isNested) {
                TableFieldInfoWrapper wrapper = this.fieldInfoCatcher.getNestedFiledByName(nestedChain, entry.getKey(), false);
                if (null == wrapper || !wrapper.getFieldInfo().havingQueryFilter() || !hasMainTableFilter || !(wrapper.getTableChain().getPojoMapping() instanceof OneToManyMapping)) continue;
                throw new CannotResolverConditionException("\u5b58\u5728\u4e00\u5bf9\u591a\u6620\u5c04\uff0c\u65e0\u6cd5\u89e3\u6790\u5bf9\u4ece\u8868\u7684\u6761\u4ef6\u8fc7\u6ee4\uff0c\u5c06\u5bfc\u81f4\u5206\u9875\u5931\u6548\uff01\t" + wrapper.getTableChain().getPojoType().getName() + "#" + wrapper.getFieldInfo().getJavaFieldName() + "\t" + (Object)((Object)wrapper.getFieldInfo().getColumn().getQueryFilterType()));
            }
            TableFieldInfo fieldInfo = this.fieldInfoCatcher.getByName(pojoType, entry.getKey(), false);
            if (!fieldInfo.havingQueryFilter()) continue;
            hasMainTableFilter = true;
        }
    }

    @Override
    public Object injectOfInsert(UpdateParam updateParam, StringBuilder sql) {
        Object instance = updateParam.getData();
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(updateParam.getPojoType()).getTableInfo();
        Map<String, TableFieldInfo> fieldInfoMap = tableInfo.getFieldInfoList().stream().filter(f -> f.getColumn().isInsertable()).collect(Collectors.toMap(TableFieldInfo::getJavaFieldName, Function.identity()));
        List<TableFieldInfo> havingConvertFields = tableInfo.getFieldInfoList().stream().filter(TableFieldInfo::havingTypeConverter).collect(Collectors.toList());
        if (instance instanceof Collection) {
            return this.providerSqlParamSources(havingConvertFields, (Collection)instance, fieldInfoMap);
        }
        return new PojoPropertySqlParameterSource(instance, fieldInfoMap, this.convert(havingConvertFields, instance));
    }

    private PojoPropertySqlParameterSource[] providerSqlParamSources(List<TableFieldInfo> fieldInfoList, Collection<?> data, Map<String, TableFieldInfo> fieldInfoMap) {
        PojoPropertySqlParameterSource[] sources = new PojoPropertySqlParameterSource[data.size()];
        int index = 0;
        for (Object o : data) {
            sources[index++] = new PojoPropertySqlParameterSource(o, fieldInfoMap, this.convert(fieldInfoList, o));
        }
        return sources;
    }

    @Override
    public void injectId(IdStrategy id, Object data) {
        if (id.getIdGenerator() != Auto.class && id.getIdGenerator() != None.class) {
            if (data instanceof Collection) {
                Collection dataRef = (Collection)data;
                Object[] ids = this.idProvider.provider(id.getIdGenerator(), data);
                int i = 0;
                for (Object o : dataRef) {
                    InvokeHelper.invokeSetter(id.getSetter(), o, ids[i++]);
                }
            } else {
                InvokeHelper.invokeSetter(id.getSetter(), data, this.idProvider.provider(id.getIdGenerator(), data)[0]);
            }
        }
    }

    private Map<TableFieldInfo, Object> convert(List<TableFieldInfo> fieldInfoList, Object data) {
        if (fieldInfoList.isEmpty()) {
            return null;
        }
        HashMap<TableFieldInfo, Object> converted = new HashMap<TableFieldInfo, Object>();
        fieldInfoList.forEach(f -> {
            TypeConverter typeConverter = this.typeConverterProvider.provider(f.getColumn().getTypeConverter());
            if (typeConverter.match(this.dialectRegister.getDialect())) {
                converted.put((TableFieldInfo)f, typeConverter.convertToDb(data, InvokeHelper.invokeGetter(f.getGetter(), data), (TableFieldInfo)f));
            }
        });
        return converted;
    }

    @Override
    public Object injectOfDelete(UpdateParam updateParam, StringBuilder sql) {
        SqlParamHolder analysis = this.conditionAnalyzer.analysis(updateParam.getPojoType(), updateParam.getCondition());
        sql.append(analysis.getSql());
        return analysis.getParam();
    }

    @Override
    public Object injectOfLogicDelete(UpdateParam updateParam, StringBuilder sql) {
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(updateParam.getPojoType()).getTableInfo();
        Map<String, TableFieldInfo> fieldInfoMap = tableInfo.getFieldInfoList().stream().filter(f -> f.getColumn().isInsertable()).collect(Collectors.toMap(TableFieldInfo::getJavaFieldName, Function.identity()));
        LogicDeleteField logicDeleteField = this.pojoTableManager.getByPojoType(updateParam.getPojoType()).getTableInfo().getLogicDeleteField();
        SqlParamHolder analysis = this.conditionAnalyzer.analysis(updateParam.getPojoType(), updateParam.getCondition());
        sql.append(analysis.getSql());
        analysis.getParam().put(logicDeleteField.getJavaFieldName(), logicDeleteField.getDeleteValue());
        return new UpdateConditionSqlParameterSource(updateParam.getData(), fieldInfoMap, null, analysis.getParam());
    }

    @Override
    public Object injectOfUpdate(UpdateParam updateParam, StringBuilder sql) {
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(updateParam.getPojoType()).getTableInfo();
        Map<String, TableFieldInfo> fieldInfoMap = tableInfo.getFieldInfoList().stream().filter(f -> f.getColumn().isInsertable()).collect(Collectors.toMap(TableFieldInfo::getJavaFieldName, Function.identity()));
        List<TableFieldInfo> havingConvertFields = tableInfo.getFieldInfoList().stream().filter(TableFieldInfo::havingTypeConverter).collect(Collectors.toList());
        SqlParamHolder analysis = this.conditionAnalyzer.analysis(updateParam.getPojoType(), updateParam.getCondition());
        sql.append(analysis.getSql());
        return new UpdateConditionSqlParameterSource(updateParam.getData(), fieldInfoMap, this.convert(havingConvertFields, updateParam.getData()), analysis.getParam());
    }

    private static final class ExistMainTableFilterHolder {
        boolean hasMainTableFilter;

        public ExistMainTableFilterHolder(boolean hasMainTableFilter) {
            this.hasMainTableFilter = hasMainTableFilter;
        }
    }
}

