/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.analyzer;

import cool.lazy.cat.orm.core.jdbc.analyzer.RowAggregator;
import cool.lazy.cat.orm.core.jdbc.dto.ExcludeFieldInfoWrapper;
import cool.lazy.cat.orm.core.jdbc.dto.FlatPojoWrapper;
import cool.lazy.cat.orm.core.jdbc.exception.MergeRowException;
import cool.lazy.cat.orm.core.jdbc.holder.TableChainHolder;
import cool.lazy.cat.orm.core.jdbc.mapping.On;
import cool.lazy.cat.orm.core.jdbc.mapping.OneToManyMapping;
import cool.lazy.cat.orm.core.jdbc.mapping.PojoMapping;
import cool.lazy.cat.orm.core.jdbc.mapping.TableChain;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.ReflectionUtils;

public class DefaultRowAggregator
implements RowAggregator {
    @Override
    public List<?> mergeRow(TableChainHolder tableChainHolder, ExcludeFieldInfoWrapper exclude, List<FlatPojoWrapper[]> wrapperList) {
        ArrayList<Object> mergeResult = new ArrayList<Object>(wrapperList.size());
        Map groupMap = wrapperList.stream().collect(Collectors.groupingBy(w -> this.getId(tableChainHolder.getTableInfo().getId().getGetter(), w[0].getPojoInstance()), LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry entry : groupMap.entrySet()) {
            Object mainPojo = ((FlatPojoWrapper[])((List)entry.getValue()).get(0))[0].getPojoInstance();
            if (((FlatPojoWrapper[])((List)entry.getValue()).get(0)).length > 1) {
                try {
                    this.merge(mainPojo, tableChainHolder.getNestedChain(), tableChainHolder.getFlatChain(), exclude, (List)entry.getValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new MergeRowException("\u5c1d\u8bd5\u5c06\u4e00\u5bf9\u591a\u3001\u4e00\u5bf9\u4e00\u3001\u591a\u5bf9\u4e00\u6620\u5c04\u5408\u5e76\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + mainPojo.getClass().getName() + "\r\n" + entry.getValue());
                }
            }
            mergeResult.add(mainPojo);
        }
        return mergeResult;
    }

    protected void merge(Object mainPojo, List<TableChain> nestedChain, List<TableChain> flatChain, ExcludeFieldInfoWrapper exclude, List<FlatPojoWrapper[]> flatPojoList) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        for (TableChain chain : nestedChain) {
            Method idGetter = chain.getId().getGetter();
            int index = flatChain.indexOf(chain) + 1;
            PojoMapping pojoMapping = chain.getPojoMapping();
            Method setter = pojoMapping.getFieldInfo().getSetter();
            if (pojoMapping instanceof OneToManyMapping) {
                Collection<Object> container = this.buildCollection(((OneToManyMapping)pojoMapping).getContainerType());
                LinkedHashSet<Object> set = new LinkedHashSet<Object>();
                for (FlatPojoWrapper[] wrappers : flatPojoList) {
                    Object pojo = wrappers[index].getPojoInstance();
                    if (null == this.getId(idGetter, pojo) || pojo.getClass() != chain.getPojoType() || !this.qualified(mainPojo, pojo, chain.getJoinCondition())) continue;
                    if (chain.hasChain() && !set.contains(pojo)) {
                        this.merge(pojo, chain.getChain(), flatChain, exclude, flatPojoList);
                    }
                    set.add(pojo);
                }
                container.addAll(set);
                if (container.isEmpty()) continue;
                setter.invoke(mainPojo, container);
                continue;
            }
            Object pojo = flatPojoList.get(0)[index].getPojoInstance();
            if (null == this.getId(idGetter, pojo)) {
                FlatPojoWrapper[] wrappers;
                Iterator<FlatPojoWrapper[]> iterator = flatPojoList.iterator();
                while (iterator.hasNext() && null == this.getId(idGetter, pojo = (wrappers = iterator.next())[index].getPojoInstance())) {
                }
            }
            if (null == this.getId(idGetter, pojo)) continue;
            if (chain.hasChain()) {
                this.merge(pojo, chain.getChain(), flatChain, exclude, flatPojoList);
            }
            setter.invoke(mainPojo, pojo);
        }
    }

    private Object getId(Method getter, Object instance) {
        if (null == instance) {
            return null;
        }
        return ReflectionUtils.invokeMethod((Method)getter, (Object)instance);
    }

    private Collection<Object> buildCollection(Class<?> collectionType) throws IllegalAccessException, InstantiationException {
        if (collectionType == List.class) {
            return new ArrayList<Object>();
        }
        if (collectionType == Set.class) {
            return new HashSet<Object>();
        }
        return (Collection)collectionType.newInstance();
    }

    protected boolean qualified(Object mainPojo, Object target, List<On> conditions) throws InvocationTargetException, IllegalAccessException {
        for (On on : conditions) {
            Object result2;
            Method foreignKeyGetter = on.getForeignKeyInfo().getGetter();
            Method targetFiledGetter = on.getTargetFiledInfo().getGetter();
            Object result1 = foreignKeyGetter.invoke(mainPojo, new Object[0]);
            if (Objects.equals(result1, result2 = targetFiledGetter.invoke(target, new Object[0]))) continue;
            return false;
        }
        return true;
    }
}

