/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.component.id;

import cool.lazy.cat.orm.core.base.util.BeanFieldUtil;
import cool.lazy.cat.orm.core.jdbc.component.id.IdGenerator;
import cool.lazy.cat.orm.core.jdbc.dialect.Dialect;
import cool.lazy.cat.orm.core.jdbc.dialect.DialectRegister;
import cool.lazy.cat.orm.core.jdbc.exception.SequenceNotFoundException;
import cool.lazy.cat.orm.core.jdbc.manager.PojoTableManager;
import cool.lazy.cat.orm.core.jdbc.mapping.IdStrategy;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public class SequenceIdGenerator
implements IdGenerator {
    @Autowired
    protected PojoTableManager pojoTableManager;
    @Autowired
    protected JdbcTemplate jdbcTemplate;
    protected Dialect dialect;

    @Autowired
    private void initDialect(DialectRegister dialectRegister) {
        this.dialect = dialectRegister.getDialect();
    }

    @Override
    public Object[] generator(Object ... args) {
        Class<?> pojoType = BeanFieldUtil.getTypeFromObj(args[0]);
        IdStrategy id = this.pojoTableManager.getByPojoType(pojoType).getTableInfo().getId();
        if (!id.havingSequence()) {
            throw new SequenceNotFoundException("pojo\u4e3b\u952e\u672a\u5b9a\u4e49\u5e8f\u5217\uff1a#" + pojoType.getName());
        }
        return this.generator(args[0], id);
    }

    protected Object[] generator(Object data, IdStrategy id) {
        if (data instanceof Collection) {
            Collection dataRef = (Collection)data;
            Object[] ids = new Object[dataRef.size()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = this.jdbcTemplate.queryForObject(this.dialect.selectSequenceNextValueSql(id.getSequenceInfo().getSchema(), id.getSequenceInfo().getName()), id.getJavaType());
            }
            return ids;
        }
        return new Object[]{this.jdbcTemplate.queryForObject(this.dialect.selectSequenceNextValueSql(id.getSequenceInfo().getSchema(), id.getSequenceInfo().getName()), id.getJavaType())};
    }
}

