/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.dialect;

import cool.lazy.cat.orm.core.base.util.CollectionUtil;
import cool.lazy.cat.orm.core.jdbc.JdbcConfig;
import cool.lazy.cat.orm.core.jdbc.dialect.Dialect;
import cool.lazy.cat.orm.core.jdbc.dialect.SimpleMysqlDialect;
import cool.lazy.cat.orm.core.jdbc.dialect.SimpleOracleDialect;
import cool.lazy.cat.orm.core.jdbc.exception.CannotFindDialectException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DialectRegister {
    @Autowired
    protected JdbcConfig jdbcConfig;
    @Autowired
    protected SimpleMysqlDialect simpleMysqlDialect;
    @Autowired
    protected SimpleOracleDialect simpleOracleDialect;
    private Dialect dialect;
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Autowired
    private void initDialect(List<Dialect> dialectList) {
        if (CollectionUtil.isEmpty(dialectList)) {
            return;
        }
        Class<?> dialectClass = this.jdbcConfig.getDialectClass();
        if (null == dialectClass) {
            Class<?> driverClass = this.jdbcConfig.getDriverClass();
            if (null != driverClass) {
                String driverName = driverClass.getName().toLowerCase();
                if (driverName.contains("mysql")) {
                    this.dialect = this.simpleMysqlDialect;
                } else if (driverName.contains("oracle")) {
                    this.dialect = this.simpleOracleDialect;
                }
            }
        } else if (Dialect.class.isAssignableFrom(dialectClass)) {
            Dialect dialect = dialectList.stream().filter(d -> d.getClass() == dialectClass).findFirst().orElse(null);
            if (null == dialect) {
                throw new CannotFindDialectException("\u65e0\u6cd5\u52a0\u8f7d\u65b9\u8a00\uff1a" + dialectClass.getName());
            }
            this.dialect = dialect;
        } else {
            throw new CannotFindDialectException("\u65e0\u6cd5\u52a0\u8f7d\u65b9\u8a00\uff1a" + dialectClass.getName() + "\uff0c\u4e0d\u662f\u4e00\u4e2a\u5b9e\u73b0\u7c7b");
        }
        if (null != this.getDialect()) {
            this.logger.info((Object)("load dialect: " + this.dialect.getClass().getName()));
        }
    }

    public Dialect getDialect() {
        return this.dialect;
    }
}

