/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.dialect;

import cool.lazy.cat.orm.core.jdbc.KeyWordConverter;
import cool.lazy.cat.orm.core.jdbc.dialect.MysqlDialect;
import cool.lazy.cat.orm.core.jdbc.dto.TableFieldInfoIndexWrapper;
import cool.lazy.cat.orm.core.jdbc.param.SearchParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class SimpleMysqlDialect
implements MysqlDialect {
    @Autowired
    protected KeyWordConverter keyWordConverter;

    @Override
    public String limitSql(SearchParam searchParam, StringBuilder originalSql, List<TableFieldInfoIndexWrapper> indexes) {
        return originalSql.append(" ").append(this.keyWordConverter.limit()).append(searchParam.getIndex()).append(",").append(searchParam.getPageSize()).toString();
    }

    @Override
    public String countSql(SearchParam searchParam, StringBuilder originalSql) {
        StringBuilder sql = new StringBuilder();
        if (searchParam.getTableInfo().havingOneToManyMapping()) {
            return sql.append(this.keyWordConverter.select()).append(this.keyWordConverter.count()).append("(").append("0").append(") ").append(this.keyWordConverter.from()).append("(").append((CharSequence)originalSql).append(" ").append(this.keyWordConverter.group()).append(this.keyWordConverter.by()).append("this_").append(".").append(searchParam.getTableInfo().getId().getDbFieldName()).append(") ").append("count_").toString();
        }
        return sql.append(this.keyWordConverter.select()).append(this.keyWordConverter.count()).append("(").append("0").append(") ").append(this.keyWordConverter.from()).append("(").append((CharSequence)originalSql).append(") ").append("count_").toString();
    }

    @Override
    public String selectSequenceCurrentValueSql(String schema, String sequenceName) {
        return this.keyWordConverter.select() + "seq_curval('" + sequenceName + "')";
    }

    @Override
    public String selectSequenceNextValueSql(String schema, String sequenceName) {
        return this.keyWordConverter.select() + "seq_nextval('" + sequenceName + "')";
    }

    @Override
    public String setSequenceValueSql(String schema, String sequenceName, Object val) {
        return this.keyWordConverter.call() + "seq_setval('" + sequenceName + "', '" + val.toString() + "')";
    }
}

