/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.dialect;

import cool.lazy.cat.orm.core.base.util.StringUtil;
import cool.lazy.cat.orm.core.jdbc.KeyWordConverter;
import cool.lazy.cat.orm.core.jdbc.dialect.OracleDialect;
import cool.lazy.cat.orm.core.jdbc.dto.TableFieldInfoIndexWrapper;
import cool.lazy.cat.orm.core.jdbc.param.SearchParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class SimpleOracleDialect
implements OracleDialect {
    @Autowired
    protected KeyWordConverter keyWordConverter;
    private static final String ROWNUM = "ROWNUM";
    private static final String ROWNUM_ALIAS_NAME = " rownum_ ";
    private static final String TEMP = "temp_";

    @Override
    public String limitSql(SearchParam searchParam, StringBuilder originalSql, List<TableFieldInfoIndexWrapper> indexes) {
        StringBuilder sql = new StringBuilder();
        if (searchParam.getIndex() > 0) {
            sql.append(this.keyWordConverter.select()).append("* ").append(this.keyWordConverter.from()).append("( ").append(this.keyWordConverter.select()).append(TEMP).append(".*, ").append(ROWNUM).append(ROWNUM_ALIAS_NAME).append(this.keyWordConverter.from()).append("(").append((CharSequence)originalSql).append(") ").append(TEMP).append(" ").append(this.keyWordConverter.where()).append(ROWNUM).append(" <= ").append(searchParam.getIndex() + searchParam.getPageSize()).append(") ").append(this.keyWordConverter.where()).append(ROWNUM_ALIAS_NAME).append("> ").append(searchParam.getIndex());
            indexes.add(null);
        } else {
            sql.append(this.keyWordConverter.select()).append("* ").append(this.keyWordConverter.from()).append("(").append((CharSequence)originalSql).append(") ").append(TEMP).append(" ").append(this.keyWordConverter.where()).append(ROWNUM).append(" <= ").append(searchParam.getPageSize());
        }
        return sql.toString();
    }

    @Override
    public String countSql(SearchParam searchParam, StringBuilder originalSql) {
        StringBuilder sql = new StringBuilder();
        if (searchParam.getTableInfo().havingOneToManyMapping()) {
            return sql.append(this.keyWordConverter.select()).append(this.keyWordConverter.count()).append("(").append("0").append(") ").append(this.keyWordConverter.from()).append("(").append((CharSequence)originalSql).append(" ").append(this.keyWordConverter.group()).append(this.keyWordConverter.by()).append("this_").append(".").append(searchParam.getTableInfo().getId().getDbFieldName()).append(") ").append("count_").toString();
        }
        return sql.append(this.keyWordConverter.select()).append(this.keyWordConverter.count()).append("(").append("0").append(") ").append(this.keyWordConverter.from()).append("(").append((CharSequence)originalSql).append(") ").append("count_").toString();
    }

    @Override
    public String selectSequenceCurrentValueSql(String schema, String sequenceName) {
        if (StringUtil.isNotBlank(schema)) {
            return this.keyWordConverter.select() + schema + "." + sequenceName + ".currval " + this.keyWordConverter.from() + "dual";
        }
        return this.keyWordConverter.select() + sequenceName + ".currval " + this.keyWordConverter.from() + "dual";
    }

    @Override
    public String selectSequenceNextValueSql(String schema, String sequenceName) {
        if (StringUtil.isNotBlank(schema)) {
            return this.keyWordConverter.select() + schema + "." + sequenceName + ".nextval " + this.keyWordConverter.from() + "dual";
        }
        return this.keyWordConverter.select() + sequenceName + ".nextval " + this.keyWordConverter.from() + "dual";
    }

    @Override
    public String setSequenceValueSql(String schema, String sequenceName, Object val) {
        return null;
    }
}

