/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.dto;

import cool.lazy.cat.orm.core.jdbc.dto.ExcludeFieldInfo;
import cool.lazy.cat.orm.core.jdbc.mapping.TableChain;
import cool.lazy.cat.orm.core.jdbc.mapping.TableFieldInfo;
import java.util.Set;
import java.util.stream.Collectors;

public class ExcludeFieldInfoWrapper {
    private Set<ExcludeFieldInfo> excludes;
    private Set<String> excludesName;

    public ExcludeFieldInfoWrapper setExcludes(Set<ExcludeFieldInfo> excludes) {
        this.excludes = excludes;
        this.excludesName = excludes.stream().map(e -> e.getFieldInfo() == null ? e.getChain().getBelongField().getJavaFieldName() : e.getFieldInfo().getJavaFieldName()).collect(Collectors.toSet());
        return this;
    }

    public boolean isExclude(TableFieldInfo info) {
        for (ExcludeFieldInfo fieldInfo : this.excludes) {
            if (!fieldInfo.excludeField() || !fieldInfo.getFieldInfo().equals(info)) continue;
            return true;
        }
        return false;
    }

    public boolean isExclude(TableChain chain) {
        for (ExcludeFieldInfo fieldInfo : this.excludes) {
            if (!fieldInfo.excludeChain() || !fieldInfo.getChain().equals(chain)) continue;
            return true;
        }
        return false;
    }

    public boolean isExclude(TableChain chain, TableFieldInfo info) {
        for (ExcludeFieldInfo fieldInfo : this.excludes) {
            if (!fieldInfo.excludeChainField() || !fieldInfo.getChain().equals(chain) || !fieldInfo.getFieldInfo().equals(info)) continue;
            return true;
        }
        return false;
    }

    public boolean isExclude(String filedName) {
        return this.excludesName.contains(filedName);
    }

    public Set<ExcludeFieldInfo> getExcludes() {
        return this.excludes;
    }

    public Set<String> getExcludesName() {
        return this.excludesName;
    }

    public ExcludeFieldInfoWrapper setExcludesName(Set<String> excludesName) {
        this.excludesName = excludesName;
        return this;
    }
}

