/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.manager;

import cool.lazy.cat.orm.core.jdbc.manager.factory.PojoTableSubjectFactory;
import cool.lazy.cat.orm.core.jdbc.manager.subject.PojoTableSubject;
import cool.lazy.cat.orm.core.manager.Manager;
import cool.lazy.cat.orm.core.manager.PojoManager;
import cool.lazy.cat.orm.core.manager.exception.UnKnowPojoException;
import cool.lazy.cat.orm.core.manager.subject.PojoSubject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class PojoTableManager
implements Manager {
    @Autowired
    protected PojoTableSubjectFactory pojoTableSubjectFactory;
    protected Map<Class<?>, PojoTableSubject> pojoTableSubjectMap;

    @Autowired
    public void initPojoTableSubject(PojoManager pojoManager) {
        List<PojoSubject> pojoSubjectList = pojoManager.getPojoSubjectList();
        this.pojoTableSubjectMap = new HashMap(pojoSubjectList.size());
        for (PojoSubject pojoSubject : pojoSubjectList) {
            Class<?> pojoType = pojoSubject.getPojoType();
            PojoTableSubject subject = (PojoTableSubject)this.pojoTableSubjectFactory.build(pojoType);
            this.pojoTableSubjectMap.put(pojoType, subject);
        }
        this.pojoTableSubjectFactory.initJoinCondition(this.pojoTableSubjectMap);
        this.pojoTableSubjectFactory.analysisTableChain(this.pojoTableSubjectMap);
    }

    public PojoTableSubject getByPojoType(Class<?> pojoType) {
        PojoTableSubject subject = this.pojoTableSubjectMap.get(pojoType);
        if (null == subject) {
            throw new UnKnowPojoException("\u672a\u5b9a\u4e49\u7684pojo\u7c7b\u578b\uff1a" + pojoType.getName());
        }
        return subject;
    }

    public Map<Class<?>, PojoTableSubject> getAllSubjectMap() {
        return this.pojoTableSubjectMap;
    }
}

