/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.manager.factory;

import cool.lazy.cat.orm.core.base.annotation.Column;
import cool.lazy.cat.orm.core.base.annotation.Id;
import cool.lazy.cat.orm.core.base.annotation.LogicDelete;
import cool.lazy.cat.orm.core.base.annotation.ManyToOne;
import cool.lazy.cat.orm.core.base.annotation.OneToMany;
import cool.lazy.cat.orm.core.base.annotation.OneToOne;
import cool.lazy.cat.orm.core.base.annotation.Pojo;
import cool.lazy.cat.orm.core.base.annotation.Table;
import cool.lazy.cat.orm.core.base.exception.FieldAlreadyExistsException;
import cool.lazy.cat.orm.core.base.util.CollectionUtil;
import cool.lazy.cat.orm.core.base.util.StringUtil;
import cool.lazy.cat.orm.core.jdbc.JdbcConfig;
import cool.lazy.cat.orm.core.jdbc.KeyWordConverter;
import cool.lazy.cat.orm.core.jdbc.component.id.IdGenerator;
import cool.lazy.cat.orm.core.jdbc.dto.CascadeLevelMapper;
import cool.lazy.cat.orm.core.jdbc.exception.CannotFindJoinConditionException;
import cool.lazy.cat.orm.core.jdbc.exception.UniqueKeyUndefinedException;
import cool.lazy.cat.orm.core.jdbc.generator.AliasNameGenerator;
import cool.lazy.cat.orm.core.jdbc.holder.TableChainHolder;
import cool.lazy.cat.orm.core.jdbc.manager.subject.PojoTableSubject;
import cool.lazy.cat.orm.core.jdbc.mapping.IdStrategy;
import cool.lazy.cat.orm.core.jdbc.mapping.LogicDeleteField;
import cool.lazy.cat.orm.core.jdbc.mapping.On;
import cool.lazy.cat.orm.core.jdbc.mapping.PojoMapping;
import cool.lazy.cat.orm.core.jdbc.mapping.TableFieldInfo;
import cool.lazy.cat.orm.core.jdbc.mapping.TableInfo;
import cool.lazy.cat.orm.core.jdbc.util.PlaceHolderUtil;
import cool.lazy.cat.orm.core.jdbc.util.TableChainBuildHelper;
import cool.lazy.cat.orm.core.manager.PojoManager;
import cool.lazy.cat.orm.core.manager.exception.CannotFindSetterMethodException;
import cool.lazy.cat.orm.core.manager.exception.MutualExclusionException;
import cool.lazy.cat.orm.core.manager.exception.NotStandardSetterMethodException;
import cool.lazy.cat.orm.core.manager.factory.SubjectFactory;
import cool.lazy.cat.orm.core.manager.subject.PojoSubject;
import cool.lazy.cat.orm.core.manager.subject.Subject;
import java.beans.MethodDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class PojoTableSubjectFactory
implements SubjectFactory {
    @Autowired
    protected KeyWordConverter keyWordConverter;
    @Autowired
    protected JdbcConfig jdbcConfig;
    @Autowired
    protected AliasNameGenerator aliasNameGenerator;
    @Autowired
    protected PojoManager pojoManager;

    @PostConstruct
    public void init() {
        TableChainBuildHelper.initAliasNameGenerator(this.aliasNameGenerator);
    }

    @Override
    public Subject build(Class<?> pojoType) {
        PojoTableSubject subject = new PojoTableSubject();
        subject.setPojoType(pojoType);
        this.initPojoTableSubjectTableInfo(subject);
        return subject;
    }

    protected void initPojoTableSubjectTableInfo(PojoTableSubject pojoTableSubject) {
        Class<?> pojoType = pojoTableSubject.getPojoType();
        Table annotation = pojoType.getAnnotation(Pojo.class).table();
        TableInfo tableInfo = new TableInfo();
        if (StringUtil.isNotBlank(annotation.tableName())) {
            tableInfo.setName(annotation.tableName());
        } else {
            tableInfo.setName(this.keyWordConverter.toDbWord(pojoType.getSimpleName()));
        }
        if (StringUtil.isNotBlank(annotation.schema())) {
            tableInfo.setSchema(PlaceHolderUtil.getDynamicSchema(annotation.schema(), this.jdbcConfig));
        }
        tableInfo.setPojoType(pojoTableSubject.getPojoType());
        pojoTableSubject.setTableInfo(tableInfo);
        this.initPojoTableSubjectFiledInfo(pojoTableSubject, tableInfo);
    }

    protected void initPojoTableSubjectFiledInfo(PojoTableSubject pojoTableSubject, TableInfo tableInfo) {
        PojoSubject pojoSubject = this.pojoManager.getByPojoType(pojoTableSubject.getPojoType());
        tableInfo.addTrigger(pojoSubject.getPojoType().getAnnotation(Pojo.class).trigger());
        List<MethodDescriptor> getterList = pojoSubject.getGetterList();
        this.filterGetter(getterList, pojoSubject.getPojoType());
        List<MethodDescriptor> setterList = pojoSubject.getSetterList();
        int index = 0;
        for (MethodDescriptor getterDes : getterList) {
            LogicDelete logicDelete;
            TableFieldInfo fieldInfo = new TableFieldInfo();
            fieldInfo.setPojoType(pojoSubject.getPojoType());
            Method getter = getterDes.getMethod();
            this.checkGetter(pojoTableSubject.getPojoType(), getter);
            Method setter = this.findSetterMethodByGetter(pojoTableSubject.getPojoType(), getter, setterList);
            getter.setAccessible(true);
            fieldInfo.setGetter(getter);
            fieldInfo.setJavaFieldName(StringUtil.upper2Lower(getter.getName().substring("get".length())));
            fieldInfo.setAliasName(this.aliasNameGenerator.generatorFiledName(fieldInfo.getJavaFieldName(), index++));
            setter.setAccessible(true);
            fieldInfo.setSetter(setter);
            fieldInfo.setJavaType(getter.getReturnType());
            Column column = getter.getAnnotation(Column.class);
            if (null != column) {
                if (StringUtil.isBlank(column.name())) {
                    fieldInfo.setDbFieldName(this.keyWordConverter.toDbWord(getter.getName().substring("get".length())));
                } else {
                    fieldInfo.setDbFieldName(column.name());
                }
                tableInfo.addFiledInfo(fieldInfo);
            }
            fieldInfo.initColumn(column);
            tableInfo.addAnnotation(getter.getAnnotation(OneToMany.class), fieldInfo.getJavaType(), fieldInfo);
            tableInfo.addAnnotation(getter.getAnnotation(OneToOne.class), fieldInfo.getJavaType(), fieldInfo);
            tableInfo.addAnnotation(getter.getAnnotation(ManyToOne.class), fieldInfo.getJavaType(), fieldInfo);
            Id idAnnotation = getter.getAnnotation(Id.class);
            if (null != idAnnotation) {
                this.setId(idAnnotation, fieldInfo, tableInfo);
            }
            if (null == (logicDelete = getter.getAnnotation(LogicDelete.class))) continue;
            this.setLogicDeleteField(logicDelete, fieldInfo, tableInfo);
        }
    }

    private void filterGetter(List<MethodDescriptor> getterList, Class<?> pojoType) {
        MethodDescriptor id = getterList.stream().filter(g -> g.getMethod().getAnnotation(Id.class) != null).findFirst().orElse(null);
        if (null == id) {
            throw new UniqueKeyUndefinedException("pojo\u672a\u5b9a\u4e49\u4e3b\u952e\uff1a" + pojoType.getName());
        }
        if (null == id.getMethod().getAnnotation(Column.class)) {
            throw new IllegalArgumentException("\u4e3b\u952e\u5b57\u6bb5\u5fc5\u987b\u5b9a\u4e49@Column\u6ce8\u89e3\uff1a" + pojoType.getName() + "#" + id.getMethod().getName());
        }
        if (!id.getMethod().getAnnotation(Column.class).insertable()) {
            throw new IllegalArgumentException("\u4e3b\u952e\u5217insertable\u5fc5\u987b\u4e3atrue\uff1a" + pojoType.getName() + "#" + id.getMethod().getName());
        }
        MethodDescriptor logicDeleteFiled = getterList.stream().filter(g -> g.getMethod().getAnnotation(LogicDelete.class) != null).findFirst().orElse(null);
        if (null != logicDeleteFiled) {
            long count = getterList.stream().filter(g -> g.getMethod().getAnnotation(LogicDelete.class) != null).count();
            if (count > 1L) {
                throw new FieldAlreadyExistsException("\u91cd\u590d\u7684\u903b\u8f91\u5220\u9664\u5b57\u6bb5\u5b9a\u4e49\uff1a" + pojoType.getName() + "#" + logicDeleteFiled.getMethod().getName());
            }
            if (null == logicDeleteFiled.getMethod().getAnnotation(Column.class)) {
                throw new IllegalArgumentException("\u903b\u8f91\u5220\u9664\u5b57\u6bb5\u5fc5\u987b\u5b9a\u4e49@Column\u6ce8\u89e3\uff1a" + pojoType.getName() + "#" + logicDeleteFiled.getMethod().getName());
            }
        }
        getterList.removeIf(g -> g.getMethod().getAnnotation(Column.class) == null && g.getMethod().getAnnotation(OneToMany.class) == null && g.getMethod().getAnnotation(OneToOne.class) == null && g.getMethod().getAnnotation(ManyToOne.class) == null || g.getMethod().getParameterTypes().length > 1);
    }

    private void checkGetter(Class<?> pojoType, Method getter) {
        Column column = getter.getAnnotation(Column.class);
        OneToMany oneToMany = getter.getAnnotation(OneToMany.class);
        OneToOne oneToOne = getter.getAnnotation(OneToOne.class);
        ManyToOne manyToOne = getter.getAnnotation(ManyToOne.class);
        long count = Stream.of(column, oneToMany, oneToOne, manyToOne).filter(Objects::nonNull).count();
        if (count > 1L) {
            throw new MutualExclusionException("Column OneToMany OneToOne ManyToOne\u4e0d\u5e94\u540c\u65f6\u51fa\u73b0\uff0c\u8bf7\u68c0\u67e5\uff1a" + pojoType.getName() + "#" + getter.getName());
        }
    }

    protected Method findSetterMethodByGetter(Class<?> pojoType, Method getter, List<MethodDescriptor> setterList) {
        String setterName = "set" + getter.getName().substring("get".length());
        for (MethodDescriptor setter : setterList) {
            boolean notMatch;
            if (!setterName.equals(setter.getName())) continue;
            Class<?> setterType = setter.getMethod().getParameterTypes()[0];
            boolean bl = notMatch = setterType != getter.getReturnType() && !setterType.isAssignableFrom(getter.getReturnType());
            if (setter.getMethod().getParameterCount() > 1 || notMatch) {
                throw new NotStandardSetterMethodException("set\u65b9\u6cd5\u4e0d\u7b26\u5408\u89c4\u8303\u3001\u6216setter getter\u53c2\u6570\u4e0d\u4e00\u81f4\uff1a" + pojoType.getName() + "#" + setter.getName());
            }
            return setter.getMethod();
        }
        throw new CannotFindSetterMethodException("\u65e0\u6cd5\u5339\u914d\u5bf9\u5e94\u7684set\u65b9\u6cd5\uff1a" + pojoType.getName() + "#" + getter.getName() + "\t\u8bf7\u68c0\u67e5\u65b9\u6cd5\u547d\u540d\u662f\u5426\u7b26\u5408\u89c4\u8303");
    }

    protected void setId(Id idAnnotation, TableFieldInfo fieldInfo, TableInfo tableInfo) {
        if (idAnnotation.idGenerator() == IdGenerator.class) {
            throw new IllegalArgumentException("\u4e0d\u662f\u4e00\u4e2a\u5b9e\u73b0\u7c7b\uff1a" + idAnnotation.idGenerator().getName());
        }
        IdStrategy id = new IdStrategy();
        BeanUtils.copyProperties((Object)fieldInfo, (Object)id);
        id.setIdGenerator(idAnnotation.idGenerator()).setSequenceInfo(idAnnotation.sequence());
        if (null != id.getSequenceInfo() && StringUtil.isNotBlank(id.getSequenceInfo().getSchema())) {
            id.getSequenceInfo().setSchema(PlaceHolderUtil.getDynamicSchema(id.getSequenceInfo().getSchema(), this.jdbcConfig));
        }
        tableInfo.setId(id);
    }

    public void setLogicDeleteField(LogicDelete logicDelete, TableFieldInfo fieldInfo, TableInfo tableInfo) {
        LogicDeleteField logicDeleteField = new LogicDeleteField();
        BeanUtils.copyProperties((Object)fieldInfo, (Object)logicDeleteField);
        logicDeleteField.setDeleteValue(logicDelete.deleteValue()).setNormalValue(logicDelete.normalValue());
        tableInfo.setLogicDeleteField(logicDeleteField);
    }

    public void initJoinCondition(Map<Class<?>, PojoTableSubject> pojoTableSubjectMap) {
        for (PojoTableSubject repositorySubject : pojoTableSubjectMap.values()) {
            if (CollectionUtil.isNotEmpty(repositorySubject.getTableInfo().getOneToOneMapping())) {
                repositorySubject.getTableInfo().getOneToOneMapping().forEach(a -> this.initJoinCondition((PojoMapping)a, pojoTableSubjectMap));
            }
            if (CollectionUtil.isNotEmpty(repositorySubject.getTableInfo().getOneToManyMapping())) {
                repositorySubject.getTableInfo().getOneToManyMapping().forEach(a -> this.initJoinCondition((PojoMapping)a, pojoTableSubjectMap));
            }
            if (!CollectionUtil.isNotEmpty(repositorySubject.getTableInfo().getManyToOneMapping())) continue;
            repositorySubject.getTableInfo().getManyToOneMapping().forEach(a -> this.initJoinCondition((PojoMapping)a, pojoTableSubjectMap));
        }
    }

    private void initJoinCondition(PojoMapping pojoMapping, Map<Class<?>, PojoTableSubject> pojoTableSubjectMap) {
        for (On condition : pojoMapping.getJoinCondition()) {
            String foreignKey = condition.getForeignField();
            String targetFiled = condition.getTargetFiled();
            Class<?> foreignPojoType = condition.getForeignPojoType();
            Class<?> targetPojoType = condition.getTargetPojoType();
            if (!pojoTableSubjectMap.containsKey(targetPojoType)) {
                throw new CannotFindJoinConditionException("\u65e0\u6cd5\u5339\u914d\u8054\u67e5\u6761\u4ef6\uff0c\u7f3a\u5931\u7684\u4f9d\u8d56\u9879\uff1a" + foreignPojoType.getName() + "#" + pojoMapping.getFieldInfo().getGetter().getName() + " -> #" + targetPojoType.getName() + "\t\u8be5\u7c7b\u53ef\u80fd\u65e0\u6cd5\u88ab\u626b\u63cf\u6216\u7f3a\u5931@Pojo");
            }
            TableFieldInfo foreignKeyFieldInfo = pojoTableSubjectMap.get(foreignPojoType).getTableInfo().getFieldInfoList().stream().filter(f -> f.getJavaFieldName().equals(foreignKey)).findFirst().orElseThrow(() -> new CannotFindJoinConditionException("\u65e0\u6cd5\u5339\u914d\u8054\u67e5\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff1a" + foreignPojoType.getName() + "#" + foreignKey + "\t" + targetPojoType.getName() + "#" + targetFiled));
            TableFieldInfo targetFieldInfo = pojoTableSubjectMap.get(targetPojoType).getTableInfo().getFieldInfoList().stream().filter(f -> f.getJavaFieldName().equals(targetFiled)).findFirst().orElseThrow(() -> new CannotFindJoinConditionException("\u65e0\u6cd5\u5339\u914d\u8054\u67e5\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff1a" + foreignPojoType.getName() + "#" + foreignKey + "\t" + targetPojoType.getName() + "#" + targetFiled));
            condition.setForeignKeyInfo(foreignKeyFieldInfo);
            condition.setTargetFiledInfo(targetFieldInfo);
        }
    }

    public void analysisTableChain(Map<Class<?>, PojoTableSubject> allSubjectMap) {
        List hasMappingSubject = allSubjectMap.values().stream().filter(this::hasMapping).collect(Collectors.toList());
        for (PojoTableSubject subject : hasMappingSubject) {
            TableInfo tableInfo = subject.getTableInfo();
            List<PojoMapping> mappings = CollectionUtil.concat(tableInfo.getOneToOneMapping(), tableInfo.getOneToManyMapping(), tableInfo.getManyToOneMapping());
            TableChainHolder holder = TableChainBuildHelper.build(tableInfo, mappings, allSubjectMap, CascadeLevelMapper.buildEmpty());
            tableInfo.setNestedChain(holder.getNestedChain());
            tableInfo.setFlatChain(holder.getFlatChain());
        }
    }

    private boolean hasMapping(PojoTableSubject subject) {
        return subject.getTableInfo().getOneToOneMapping() != null || subject.getTableInfo().getOneToManyMapping() != null || subject.getTableInfo().getManyToOneMapping() != null;
    }
}

