/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.mapping;

import cool.lazy.cat.orm.core.jdbc.component.convert.TypeConverter;
import cool.lazy.cat.orm.core.jdbc.component.validator.Validator;
import cool.lazy.cat.orm.core.jdbc.condition.ConditionType;
import cool.lazy.cat.orm.core.jdbc.mapping.ValidatorInfo;

public class Column {
    private String name;
    private ConditionType queryFilter;
    private Class<? extends TypeConverter> typeConverter;
    private boolean insertable;
    private boolean updatable;
    private boolean notNull;
    private int minLength;
    private int maxLength;
    private String minLengthErrorMsg;
    private String maxLengthErrorMsg;
    private ValidatorInfo validatorInfo;

    public Column(cool.lazy.cat.orm.core.base.annotation.Column column) {
        this.name = column.name();
        this.queryFilter = column.queryFilter();
        this.typeConverter = column.typeConverter();
        this.insertable = column.insertable();
        this.updatable = column.updatable();
        this.notNull = column.notNull();
        this.minLength = column.minLength();
        this.maxLength = column.maxLength();
        this.minLengthErrorMsg = column.minLengthErrorMsg();
        this.maxLengthErrorMsg = column.maxLengthErrorMsg();
        this.validatorInfo = new ValidatorInfo(column.validator());
    }

    public ConditionType getQueryFilterType() {
        return this.queryFilter == null ? ConditionType.NONE : this.queryFilter;
    }

    public boolean havingTypeConverter() {
        return this.typeConverter != TypeConverter.class;
    }

    public boolean havingValidator() {
        return this.validatorInfo != null && this.validatorInfo.getValidator() != Validator.class;
    }

    public boolean havingSimpleValidate() {
        return this.notNull || this.minLength > 0 || this.maxLength > -1;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public boolean getNotNull() {
        return this.notNull;
    }

    public String getName() {
        return this.name;
    }

    public Column setName(String name) {
        this.name = name;
        return this;
    }

    public ConditionType getQueryFilter() {
        return this.queryFilter;
    }

    public Column setQueryFilter(ConditionType queryFilter) {
        this.queryFilter = queryFilter;
        return this;
    }

    public Class<? extends TypeConverter> getTypeConverter() {
        return this.typeConverter;
    }

    public Column setTypeConverter(Class<? extends TypeConverter> typeConverter) {
        this.typeConverter = typeConverter;
        return this;
    }

    public Column setInsertable(boolean insertable) {
        this.insertable = insertable;
        return this;
    }

    public Column setUpdatable(boolean updatable) {
        this.updatable = updatable;
        return this;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public Column setNotNull(boolean notNull) {
        this.notNull = notNull;
        return this;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public Column setMinLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public Column setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public String getMinLengthErrorMsg() {
        return this.minLengthErrorMsg;
    }

    public Column setMinLengthErrorMsg(String minLengthErrorMsg) {
        this.minLengthErrorMsg = minLengthErrorMsg;
        return this;
    }

    public String getMaxLengthErrorMsg() {
        return this.maxLengthErrorMsg;
    }

    public Column setMaxLengthErrorMsg(String maxLengthErrorMsg) {
        this.maxLengthErrorMsg = maxLengthErrorMsg;
        return this;
    }

    public ValidatorInfo getValidatorInfo() {
        return this.validatorInfo;
    }

    public Column setValidatorInfo(ValidatorInfo validatorInfo) {
        this.validatorInfo = validatorInfo;
        return this;
    }
}

