/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.mapping;

import cool.lazy.cat.orm.core.base.annotation.ManyToOne;
import cool.lazy.cat.orm.core.base.annotation.OneToMany;
import cool.lazy.cat.orm.core.base.annotation.OneToOne;
import cool.lazy.cat.orm.core.base.annotation.Trigger;
import cool.lazy.cat.orm.core.base.exception.FieldAlreadyExistsException;
import cool.lazy.cat.orm.core.base.exception.UnsupportedTypeException;
import cool.lazy.cat.orm.core.base.util.CollectionUtil;
import cool.lazy.cat.orm.core.jdbc.mapping.IdStrategy;
import cool.lazy.cat.orm.core.jdbc.mapping.LogicDeleteField;
import cool.lazy.cat.orm.core.jdbc.mapping.ManyToOneMapping;
import cool.lazy.cat.orm.core.jdbc.mapping.OneToManyMapping;
import cool.lazy.cat.orm.core.jdbc.mapping.OneToOneMapping;
import cool.lazy.cat.orm.core.jdbc.mapping.TableChain;
import cool.lazy.cat.orm.core.jdbc.mapping.TableFieldInfo;
import cool.lazy.cat.orm.core.jdbc.mapping.TriggerInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.core.ResolvableType;

public class TableInfo {
    private Class<?> pojoType;
    private String name;
    private String schema;
    private IdStrategy id;
    private List<TableFieldInfo> fieldInfoList;
    private List<OneToManyMapping> oneToManyMapping;
    private List<OneToOneMapping> oneToOneMapping;
    private List<ManyToOneMapping> manyToOneMapping;
    private List<TableChain> nestedChain;
    private List<TableChain> flatChain;
    private List<TriggerInfo> triggerInfoList;
    private LogicDeleteField logicDeleteField;

    public void setId(IdStrategy id) {
        if (null != this.id) {
            throw new FieldAlreadyExistsException("\u91cd\u590d\u7684id\u5b9a\u4e49\uff1a" + this.pojoType.getName() + "#" + id.getGetter().getName());
        }
        this.id = id;
    }

    public void addFiledInfo(TableFieldInfo fieldInfo) {
        if (this.fieldInfoList == null) {
            this.fieldInfoList = new ArrayList<TableFieldInfo>();
        }
        this.fieldInfoList.add(fieldInfo);
    }

    public void addAnnotation(OneToMany oneToMany, Class<?> containerType, TableFieldInfo fieldInfo) {
        if (null == oneToMany) {
            return;
        }
        if (null == this.oneToManyMapping) {
            this.oneToManyMapping = new ArrayList<OneToManyMapping>();
        }
        if (!Collection.class.isAssignableFrom(containerType)) {
            throw new UnsupportedTypeException("\u6682\u4e0d\u652f\u6301\u7684\u96c6\u5408\u7c7b\u578b\uff1a" + fieldInfo.getPojoType().getName() + "#" + fieldInfo.getGetter().getName() + "#" + containerType.getName());
        }
        Class rawClass = ResolvableType.forMethodReturnType((Method)fieldInfo.getGetter()).getGeneric(new int[]{0}).getRawClass();
        if (null == rawClass) {
            throw new NullPointerException("\u5b57\u6bb5\u6cdb\u578b\u4e3a\u7a7a\uff1a" + fieldInfo.getPojoType().getName() + "#" + fieldInfo.getGetter().getName());
        }
        this.oneToManyMapping.add(new OneToManyMapping(oneToMany).setJavaType(rawClass).setFieldInfo(fieldInfo).setContainerType(containerType).addJoinCondition(oneToMany.condition(), this.pojoType, rawClass));
    }

    public void addAnnotation(OneToOne oneToOne, Class<?> javaType, TableFieldInfo fieldInfo) {
        if (null == oneToOne || null == javaType) {
            return;
        }
        if (null == this.oneToOneMapping) {
            this.oneToOneMapping = new ArrayList<OneToOneMapping>();
        }
        this.oneToOneMapping.add(new OneToOneMapping(oneToOne).setJavaType(javaType).setFieldInfo(fieldInfo).addJoinCondition(oneToOne.condition(), this.pojoType, javaType));
    }

    public void addAnnotation(ManyToOne manyToOne, Class<?> javaType, TableFieldInfo fieldInfo) {
        if (null == manyToOne || null == javaType) {
            return;
        }
        if (null == this.manyToOneMapping) {
            this.manyToOneMapping = new ArrayList<ManyToOneMapping>();
        }
        this.manyToOneMapping.add(new ManyToOneMapping(manyToOne).setJavaType(javaType).setFieldInfo(fieldInfo).addJoinCondition(manyToOne.condition(), this.pojoType, javaType));
    }

    public void addTrigger(Trigger[] triggers) {
        if (CollectionUtil.isEmpty(triggers)) {
            return;
        }
        if (null == this.triggerInfoList) {
            this.triggerInfoList = new ArrayList<TriggerInfo>(triggers.length);
        }
        List triggerList = Arrays.stream(triggers).sorted(Comparator.comparingInt(Trigger::sort)).collect(Collectors.toList());
        for (Trigger trigger : triggerList) {
            if (cool.lazy.cat.orm.core.jdbc.component.trigger.Trigger.class == trigger.type()) {
                throw new IllegalArgumentException("\u4e0d\u662f\u4e00\u4e2a\u5b9e\u73b0\u7c7b\uff1a" + trigger.type().getName());
            }
            this.triggerInfoList.add(new TriggerInfo(trigger));
        }
        this.triggerInfoList.sort(Comparator.comparingInt(TriggerInfo::getSort));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableInfo tableInfo = (TableInfo)o;
        if (!Objects.equals(this.name, tableInfo.name)) {
            return false;
        }
        return Objects.equals(this.schema, tableInfo.schema);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
        return result;
    }

    public String getFullName() {
        if (null != this.schema) {
            return this.schema + "." + this.name;
        }
        return this.name;
    }

    public boolean isNested() {
        return CollectionUtil.isNotEmpty(this.nestedChain);
    }

    public boolean havingOneToManyMapping() {
        return this.isNested() && CollectionUtil.isNotEmpty(this.oneToManyMapping);
    }

    public boolean havingTrigger() {
        return CollectionUtil.isNotEmpty(this.triggerInfoList);
    }

    public Class<?> getPojoType() {
        return this.pojoType;
    }

    public TableInfo setPojoType(Class<?> pojoType) {
        this.pojoType = pojoType;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public TableInfo setName(String name) {
        this.name = name;
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public TableInfo setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public IdStrategy getId() {
        return this.id;
    }

    public List<TableFieldInfo> getFieldInfoList() {
        return this.fieldInfoList;
    }

    public TableInfo setFieldInfoList(List<TableFieldInfo> fieldInfoList) {
        this.fieldInfoList = fieldInfoList;
        return this;
    }

    public List<OneToManyMapping> getOneToManyMapping() {
        return this.oneToManyMapping;
    }

    public TableInfo setOneToManyMapping(List<OneToManyMapping> oneToManyMapping) {
        this.oneToManyMapping = oneToManyMapping;
        return this;
    }

    public List<OneToOneMapping> getOneToOneMapping() {
        return this.oneToOneMapping;
    }

    public TableInfo setOneToOneMapping(List<OneToOneMapping> oneToOneMapping) {
        this.oneToOneMapping = oneToOneMapping;
        return this;
    }

    public List<ManyToOneMapping> getManyToOneMapping() {
        return this.manyToOneMapping;
    }

    public TableInfo setManyToOneMapping(List<ManyToOneMapping> manyToOneMapping) {
        this.manyToOneMapping = manyToOneMapping;
        return this;
    }

    public List<TableChain> getNestedChain() {
        return this.nestedChain;
    }

    public TableInfo setNestedChain(List<TableChain> nestedChain) {
        this.nestedChain = nestedChain;
        return this;
    }

    public List<TableChain> getFlatChain() {
        return this.flatChain;
    }

    public TableInfo setFlatChain(List<TableChain> flatChain) {
        this.flatChain = flatChain;
        return this;
    }

    public List<TriggerInfo> getTriggerInfoList() {
        return this.triggerInfoList;
    }

    public TableInfo setTriggerInfoList(List<TriggerInfo> triggerInfoList) {
        this.triggerInfoList = triggerInfoList;
        return this;
    }

    public LogicDeleteField getLogicDeleteField() {
        return this.logicDeleteField;
    }

    public TableInfo setLogicDeleteField(LogicDeleteField logicDeleteField) {
        this.logicDeleteField = logicDeleteField;
        return this;
    }
}

