/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.provider.impl;

import cool.lazy.cat.orm.core.base.exception.InitFailedException;
import cool.lazy.cat.orm.core.jdbc.component.id.IdGenerator;
import cool.lazy.cat.orm.core.jdbc.provider.IdProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultIdProvider
implements IdProvider {
    protected Map<Class<? extends IdGenerator>, IdGenerator> idGeneratorMap = new HashMap<Class<? extends IdGenerator>, IdGenerator>();

    @Autowired(required=false)
    private void initGeneratorMap(List<IdGenerator> idGeneratorList) {
        this.idGeneratorMap = idGeneratorList.stream().collect(Collectors.toMap(Object::getClass, Function.identity()));
    }

    @Override
    public Object[] provider(Class<? extends IdGenerator> type, Object ... args) {
        IdGenerator idGenerator = this.idGeneratorMap.get(type);
        if (null == idGenerator) {
            try {
                idGenerator = type.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new InitFailedException("\u521d\u59cb\u5316idGenerator\u5931\u8d25\uff01");
            }
            this.idGeneratorMap.put(type, idGenerator);
        }
        return idGenerator.generator(args);
    }
}

