/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.provider.impl;

import cool.lazy.cat.orm.core.base.exception.UnsupportedTypeException;
import cool.lazy.cat.orm.core.base.util.CollectionUtil;
import cool.lazy.cat.orm.core.base.util.Ignorer;
import cool.lazy.cat.orm.core.base.util.InvokeHelper;
import cool.lazy.cat.orm.core.jdbc.KeyWordConverter;
import cool.lazy.cat.orm.core.jdbc.analyzer.ConditionAnalyzer;
import cool.lazy.cat.orm.core.jdbc.analyzer.FieldInfoCatcher;
import cool.lazy.cat.orm.core.jdbc.analyzer.ParameterInjector;
import cool.lazy.cat.orm.core.jdbc.component.id.Auto;
import cool.lazy.cat.orm.core.jdbc.component.validator.SimpleValidator;
import cool.lazy.cat.orm.core.jdbc.component.validator.Validator;
import cool.lazy.cat.orm.core.jdbc.dialect.Dialect;
import cool.lazy.cat.orm.core.jdbc.dialect.DialectRegister;
import cool.lazy.cat.orm.core.jdbc.dto.CountHolder;
import cool.lazy.cat.orm.core.jdbc.dto.ExcludeFieldInfoWrapper;
import cool.lazy.cat.orm.core.jdbc.dto.TableFieldInfoIndexWrapper;
import cool.lazy.cat.orm.core.jdbc.dto.TableFieldInfoWrapper;
import cool.lazy.cat.orm.core.jdbc.exception.EmptyColumnException;
import cool.lazy.cat.orm.core.jdbc.exception.FieldDoesNotExistException;
import cool.lazy.cat.orm.core.jdbc.handle.ValidateHandler;
import cool.lazy.cat.orm.core.jdbc.holder.SearchSqlParamHolder;
import cool.lazy.cat.orm.core.jdbc.holder.SearchSqlParamIndexHolder;
import cool.lazy.cat.orm.core.jdbc.holder.SqlParamHolder;
import cool.lazy.cat.orm.core.jdbc.holder.UpdateSqlParamHolder;
import cool.lazy.cat.orm.core.jdbc.manager.PojoTableManager;
import cool.lazy.cat.orm.core.jdbc.mapping.IdStrategy;
import cool.lazy.cat.orm.core.jdbc.mapping.On;
import cool.lazy.cat.orm.core.jdbc.mapping.TableChain;
import cool.lazy.cat.orm.core.jdbc.mapping.TableFieldInfo;
import cool.lazy.cat.orm.core.jdbc.mapping.TableInfo;
import cool.lazy.cat.orm.core.jdbc.param.SearchParam;
import cool.lazy.cat.orm.core.jdbc.param.SimpleSearchParam;
import cool.lazy.cat.orm.core.jdbc.param.SimpleUpdateParam;
import cool.lazy.cat.orm.core.jdbc.param.UpdateParam;
import cool.lazy.cat.orm.core.jdbc.provider.SqlParamProvider;
import cool.lazy.cat.orm.core.jdbc.provider.TriggerProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class DefaultSqlParamProvider
implements SqlParamProvider {
    @Autowired
    protected KeyWordConverter keyWordConverter;
    @Autowired
    protected PojoTableManager pojoTableManager;
    @Autowired
    protected FieldInfoCatcher fieldInfoCatcher;
    @Autowired
    protected ConditionAnalyzer conditionAnalyzer;
    @Autowired
    protected ParameterInjector parameterInjector;
    @Autowired
    protected ValidateHandler validateHandler;
    @Autowired
    protected TriggerProvider triggerProvider;
    protected Dialect dialect;
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final Validator simpleValidator = new SimpleValidator();

    @Autowired
    private void initDialect(DialectRegister dialectRegister) {
        this.dialect = dialectRegister.getDialect();
    }

    @Override
    public SearchSqlParamIndexHolder getSelectSql(SearchParam searchParam) {
        TableInfo tableInfo = searchParam.getTableInfo();
        ExcludeFieldInfoWrapper exclude = this.fieldInfoCatcher.filterExclude(searchParam.getPojoType(), searchParam.getNestedChain(), searchParam.getIgnorer());
        StringBuilder sql = new StringBuilder();
        sql.append(this.keyWordConverter.select());
        CountHolder countHolder = new CountHolder(0);
        ArrayList<TableFieldInfoIndexWrapper> indexes = new ArrayList<TableFieldInfoIndexWrapper>(100);
        this.renderTableField(sql, "this_", tableInfo.getFieldInfoList(), null, exclude, countHolder, indexes);
        if (tableInfo.isNested()) {
            this.generateChainField(sql, searchParam.getNestedChain(), exclude, countHolder, indexes);
        }
        this.tailCutting(sql);
        sql.append(this.keyWordConverter.from()).append(tableInfo.getFullName()).append(" ").append("this_").append(" ");
        if (tableInfo.isNested()) {
            this.generateChainJoin(sql, searchParam.getNestedChain(), "this_", exclude);
        }
        Object param = this.parameterInjector.injectOfSelect(searchParam, sql);
        if (null != searchParam.getOrderBy() && CollectionUtil.isNotEmpty(searchParam.getOrderBy().getFields())) {
            this.oderBy(sql, searchParam);
        }
        if (searchParam.needPaging()) {
            if (null != this.dialect) {
                sql = new StringBuilder(this.dialect.limitSql(searchParam, sql, indexes));
            } else {
                this.logger.warn((Object)"\u672a\u914d\u7f6e\u6570\u636e\u5e93\u65b9\u8a00\uff0c\u5206\u9875\u5931\u6548");
            }
        }
        SearchSqlParamHolder searchSqlParamHolder = new SearchSqlParamHolder(sql);
        this.adapterParam(searchSqlParamHolder, param);
        return new SearchSqlParamIndexHolder(searchSqlParamHolder, indexes, exclude);
    }

    protected void oderBy(StringBuilder sql, SearchParam searchParam) {
        sql.append(this.keyWordConverter.order()).append(this.keyWordConverter.by());
        String[] fields = searchParam.getOrderBy().getFields();
        for (int i = 0; i < fields.length; ++i) {
            String fieldName;
            if (i > 0) {
                sql.append(",");
            }
            if ((fieldName = fields[i]).contains(".")) {
                TableFieldInfoWrapper wrapper = this.fieldInfoCatcher.getNestedFiledByName(searchParam.getNestedChain(), fieldName, true);
                sql.append(wrapper.getTableChain().getAliasName()).append(".").append(wrapper.getFieldInfo().getDbFieldName());
                continue;
            }
            TableFieldInfo fieldInfo = this.fieldInfoCatcher.getByName(searchParam.getPojoType(), fieldName, true);
            sql.append("this_").append(".").append(fieldInfo.getDbFieldName());
        }
        sql.append(" ").append(searchParam.getOrderBy().isAsc() ? this.keyWordConverter.asc() : this.keyWordConverter.desc());
    }

    protected void generateChainField(StringBuilder sql, List<TableChain> nestedChainList, ExcludeFieldInfoWrapper exclude, CountHolder countHolder, List<TableFieldInfoIndexWrapper> infoIndexes) {
        for (TableChain chain : nestedChainList) {
            if (exclude.isExclude(chain)) continue;
            TableInfo joinTable = this.pojoTableManager.getByPojoType(chain.getPojoType()).getTableInfo();
            String joinTableName = chain.getAliasName();
            this.renderTableField(sql, joinTableName, joinTable.getFieldInfoList(), chain, exclude, countHolder, infoIndexes);
            if (!chain.hasChain()) continue;
            this.generateChainField(sql, chain.getChain(), exclude, countHolder, infoIndexes);
        }
    }

    protected void generateChainJoin(StringBuilder sql, List<TableChain> chainList, String preChainName, ExcludeFieldInfoWrapper exclude) {
        for (TableChain chain : chainList) {
            if (exclude.isExclude(chain)) continue;
            TableInfo joinTable = this.pojoTableManager.getByPojoType(chain.getPojoType()).getTableInfo();
            String joinTableFullName = joinTable.getFullName();
            String joinTableName = chain.getAliasName();
            sql.append(this.keyWordConverter.left()).append(this.keyWordConverter.join()).append(" ").append(joinTableFullName).append(" ").append(joinTableName).append(" ").append(this.keyWordConverter.on()).append(" ");
            this.renderJoinCondition(sql, chain.getJoinCondition(), joinTableName, preChainName);
            if (!chain.hasChain()) continue;
            this.generateChainJoin(sql, chain.getChain(), joinTableName, exclude);
        }
    }

    protected void renderJoinCondition(StringBuilder sql, List<On> joinCondition, String joinTable, String originalTable) {
        for (int i = 0; i < joinCondition.size(); ++i) {
            On on = joinCondition.get(i);
            if (i > 0) {
                sql.append(this.keyWordConverter.and());
            }
            sql.append(joinTable).append(".").append(on.getTargetFiledInfo().getDbFieldName()).append(" = ").append(originalTable).append(".").append(on.getForeignKeyInfo().getDbFieldName()).append(" ");
        }
    }

    protected void renderTableField(StringBuilder sql, String tableAliasName, List<TableFieldInfo> fieldInfoList, TableChain chain, ExcludeFieldInfoWrapper exclude, CountHolder countHolder, List<TableFieldInfoIndexWrapper> infoIndexes) {
        for (TableFieldInfo info : fieldInfoList) {
            if (exclude.isExclude(info) || null != chain && exclude.isExclude(chain, info)) continue;
            if (null != tableAliasName) {
                sql.append(tableAliasName).append(".").append(info.getDbFieldName()).append(" ").append(this.keyWordConverter.as()).append("\"").append(tableAliasName).append(".").append(info.getAliasName()).append("\"").append(", ");
                ++countHolder.count;
                infoIndexes.add(new TableFieldInfoIndexWrapper().setIndex(countHolder.count).setFieldInfo(info).setChainFlatIndex(chain == null ? -1 : chain.getFlatIndex()));
                continue;
            }
            sql.append(info.getDbFieldName()).append(" ").append(", ");
        }
    }

    private void tailCutting(StringBuilder sql) {
        sql.deleteCharAt(sql.length() - 1);
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" ");
    }

    @Override
    public SearchSqlParamIndexHolder getCountSql(SearchParam searchParam) {
        SimpleSearchParam copySqlParam = new SimpleSearchParam(searchParam.getTableInfo());
        BeanUtils.copyProperties((Object)searchParam, copySqlParam);
        SearchSqlParamIndexHolder paramIndexHolder = this.getSelectSql(((SimpleSearchParam)copySqlParam.setPageSize(-1)).setOrderBy(null));
        StringBuilder sql = new StringBuilder(paramIndexHolder.getSql());
        sql = null != this.dialect ? new StringBuilder(this.dialect.countSql(copySqlParam, sql)) : new StringBuilder().append(this.keyWordConverter.select()).append(this.keyWordConverter.count()).append("(0)").append(this.keyWordConverter.from()).append("(").append((CharSequence)sql).append(") ").append("count_");
        return new SearchSqlParamIndexHolder(new SearchSqlParamHolder(sql, paramIndexHolder.getParam()), null, null);
    }

    @Override
    public SqlParamHolder getInsertSql(UpdateParam updateParam) {
        this.checkData(updateParam.getData());
        Class<?> pojoType = this.getTypeFromData(updateParam.getData());
        StringBuilder sql = new StringBuilder();
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(pojoType).getTableInfo();
        IdStrategy id = tableInfo.getId();
        Map fieldInfoMap = tableInfo.getFieldInfoList().stream().filter(f -> f.getColumn().isInsertable()).collect(Collectors.toMap(TableFieldInfo::getJavaFieldName, Function.identity()));
        if (id.getIdGenerator() == Auto.class) {
            fieldInfoMap.remove(id.getJavaFieldName());
        }
        sql.append(this.keyWordConverter.insert()).append(this.keyWordConverter.into()).append(tableInfo.getFullName()).append(" ");
        sql.append("(");
        fieldInfoMap.values().forEach(f -> sql.append(f.getDbFieldName()).append(", "));
        this.tailCutting(sql);
        sql.append(") ");
        sql.append(this.keyWordConverter.values());
        sql.append("(");
        fieldInfoMap.values().forEach(f -> sql.append(":").append(f.getJavaFieldName()).append(", "));
        this.tailCutting(sql);
        sql.append(") ");
        this.validate(tableInfo.getFieldInfoList(), updateParam.getData(), true);
        this.parameterInjector.injectId(tableInfo.getId(), updateParam.getData());
        this.trigger(tableInfo, updateParam.getData(), true);
        Object param = this.parameterInjector.injectOfInsert(new SimpleUpdateParam(updateParam).setPojoType(pojoType), null);
        UpdateSqlParamHolder holder = new UpdateSqlParamHolder(sql);
        this.adapterParam(holder, param);
        return holder;
    }

    private void checkData(Object data) {
        if (null == data) {
            throw new NullPointerException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (data.getClass().isArray()) {
            throw new UnsupportedTypeException("\u4e0d\u652f\u6301\u6570\u7ec4\uff0c\u671f\u671b\u7684\u7c7b\u578b\uff1a" + Collection.class.getName());
        }
    }

    private Class<?> getTypeFromData(Object obj) {
        Iterator iterator;
        if (obj instanceof Collection && (iterator = ((Collection)obj).iterator()).hasNext()) {
            Object o = iterator.next();
            return o.getClass();
        }
        return obj.getClass();
    }

    private void trigger(TableInfo tableInfo, Object data, boolean onInsert) {
        if (tableInfo.havingTrigger()) {
            tableInfo.getTriggerInfoList().forEach(t -> this.triggerProvider.provider(t.getTrigger()).execute(data, tableInfo, onInsert));
        }
    }

    private void validate(List<TableFieldInfo> fieldInfoList, Object data, boolean onInsert) {
        List<TableFieldInfo> simpleValidate;
        if (onInsert) {
            fieldInfoList = fieldInfoList.stream().filter(f -> f.havingValidator() && f.insertable()).collect(Collectors.toList());
            simpleValidate = fieldInfoList.stream().filter(f -> f.havingSimpleValidator() && f.insertable()).collect(Collectors.toList());
        } else {
            fieldInfoList = fieldInfoList.stream().filter(f -> f.havingValidator() && f.updatable()).collect(Collectors.toList());
            simpleValidate = fieldInfoList.stream().filter(f -> f.havingSimpleValidator() && f.updatable()).collect(Collectors.toList());
        }
        fieldInfoList.forEach(f -> this.validateHandler.handle((TableFieldInfo)f, data));
        this.simpledValidate(simpleValidate, data);
    }

    private void simpledValidate(List<TableFieldInfo> simpleValidate, Object data) {
        block5: {
            if (simpleValidate.isEmpty()) break block5;
            if (data instanceof Collection) {
                Collection dataRef = (Collection)data;
                for (Object o : dataRef) {
                    for (TableFieldInfo s : simpleValidate) {
                        this.simpleValidator.validate(s.getColumn(), InvokeHelper.invokeGetter(s.getGetter(), o));
                    }
                }
            } else {
                for (TableFieldInfo s : simpleValidate) {
                    this.simpleValidator.validate(s.getColumn(), InvokeHelper.invokeGetter(s.getGetter(), data));
                }
            }
        }
    }

    @Override
    public SqlParamHolder getUpdateSql(UpdateParam updateParam) {
        Object data = updateParam.getData();
        this.checkData(data);
        String[] ignoreFields = updateParam.getIgnoreFields();
        Class<?> pojoType = this.getTypeFromData(data);
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(pojoType).getTableInfo();
        List<TableFieldInfo> fieldInfoList = tableInfo.getFieldInfoList().stream().filter(f -> f.getColumn().isUpdatable()).collect(Collectors.toList());
        ArrayList<String> ignoreFieldList = new ArrayList<String>(fieldInfoList.size());
        if (updateParam.getIgnoreNull()) {
            this.filterNull(data, fieldInfoList, ignoreFieldList);
        }
        if (null != ignoreFields && ignoreFields.length > 0) {
            if (!this.fieldInfoCatcher.pojoFieldOnly(pojoType, ignoreFields)) {
                throw new UnsupportedOperationException("\u4fee\u6539\u64cd\u4f5c\u53ea\u5141\u8bb8\u64cd\u4f5c\u672c\u5bf9\u8c61\u4e2d\u7684\u5c5e\u6027 #" + pojoType.getName());
            }
            this.filterIgnore(ignoreFieldList, ignoreFields);
        }
        if (ignoreFieldList.size() >= fieldInfoList.size()) {
            throw new EmptyColumnException("\u6240\u6709\u5b57\u6bb5\u4e3a\u7a7a\u6216\u5df2\u88ab\u5ffd\u7565\uff01" + pojoType.getName());
        }
        ExcludeFieldInfoWrapper excludeFieldInfoWrapper = this.fieldInfoCatcher.filterExclude(pojoType, tableInfo.getNestedChain(), Ignorer.build(ignoreFieldList.toArray(new String[0])));
        List<TableFieldInfo> effectiveFields = tableInfo.getFieldInfoList().stream().filter(f -> !excludeFieldInfoWrapper.isExclude(f.getJavaFieldName())).collect(Collectors.toList());
        this.validate(effectiveFields, data, false);
        this.trigger(tableInfo, data, false);
        StringBuilder sql = new StringBuilder();
        sql.append(this.keyWordConverter.update()).append(tableInfo.getFullName()).append(" ").append(this.keyWordConverter.set());
        for (TableFieldInfo fieldInfo : effectiveFields) {
            sql.append(fieldInfo.getDbFieldName()).append(" =:").append(fieldInfo.getJavaFieldName()).append(",");
        }
        sql.deleteCharAt(sql.length() - 1).append(" ");
        UpdateSqlParamHolder holder = new UpdateSqlParamHolder(sql);
        Object param = this.parameterInjector.injectOfUpdate(new SimpleUpdateParam(updateParam).setPojoType(pojoType), sql);
        this.adapterParam(holder, param);
        return holder;
    }

    private void filterNull(Object instance, List<TableFieldInfo> fieldInfoList, List<String> columnNameList) {
        fieldInfoList.stream().filter(f -> InvokeHelper.invokeGetter(f.getGetter(), instance) == null).forEach(f -> columnNameList.add(f.getJavaFieldName()));
    }

    private void filterIgnore(List<String> columnNameList, String[] ignoreFields) {
        columnNameList.addAll(Arrays.asList(ignoreFields));
    }

    @Override
    public SqlParamHolder getDeleteSql(UpdateParam updateParam) {
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(updateParam.getPojoType()).getTableInfo();
        StringBuilder sql = new StringBuilder();
        sql.append(this.keyWordConverter.delete()).append(this.keyWordConverter.from()).append(tableInfo.getFullName()).append(" ");
        Object param = this.parameterInjector.injectOfDelete(updateParam, sql);
        UpdateSqlParamHolder holder = new UpdateSqlParamHolder(sql);
        this.adapterParam(holder, param);
        return holder;
    }

    @Override
    public SqlParamHolder getLogicDeleteSql(UpdateParam updateParam) {
        Class<?> pojoType = this.getTypeFromData(updateParam.getData());
        TableInfo tableInfo = this.pojoTableManager.getByPojoType(pojoType).getTableInfo();
        if (null == tableInfo.getLogicDeleteField()) {
            throw new FieldDoesNotExistException("pojo\u4e0d\u5b58\u5728\u903b\u8f91\u5220\u9664\u5b57\u6bb5\uff1a#" + tableInfo.getPojoType().getName());
        }
        StringBuilder sql = new StringBuilder();
        this.trigger(tableInfo, updateParam.getData(), false);
        sql.append(this.keyWordConverter.update()).append(tableInfo.getFullName()).append(" ").append(this.keyWordConverter.set()).append(tableInfo.getLogicDeleteField().getDbFieldName()).append(" =:").append(tableInfo.getLogicDeleteField().getJavaFieldName()).append(" ");
        Object param = this.parameterInjector.injectOfLogicDelete(new SimpleUpdateParam(updateParam).setPojoType(pojoType), sql);
        UpdateSqlParamHolder holder = new UpdateSqlParamHolder(sql);
        this.adapterParam(holder, param);
        return holder;
    }

    private void adapterParam(SqlParamHolder holder, Object param) {
        if (null == param) {
            return;
        }
        if (param instanceof Map) {
            holder.setParam((Map)param);
        } else if (param instanceof SqlParameterSource) {
            holder.setParamSource((SqlParameterSource)param);
        } else if (param.getClass().isArray() && ((Object[])param).length > 0 && ((Object[])param)[0] instanceof SqlParameterSource) {
            holder.setParamSources((SqlParameterSource[])param);
        }
    }
}

