/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.provider.impl;

import cool.lazy.cat.orm.core.base.exception.InitFailedException;
import cool.lazy.cat.orm.core.jdbc.component.trigger.Trigger;
import cool.lazy.cat.orm.core.jdbc.provider.TriggerProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultTriggerProvider
implements TriggerProvider {
    protected Map<Class<? extends Trigger>, Trigger> triggerMap = new HashMap<Class<? extends Trigger>, Trigger>();

    @Autowired(required=false)
    private void initTriggerMap(List<Trigger> triggerList) {
        this.triggerMap = triggerList.stream().collect(Collectors.toMap(Object::getClass, Function.identity()));
    }

    @Override
    public Trigger provider(Class<? extends Trigger> triggerType) {
        Trigger trigger = this.triggerMap.get(triggerType);
        if (null == trigger) {
            try {
                trigger = triggerType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new InitFailedException("\u521d\u59cb\u5316trigger\u5931\u8d25\uff01");
            }
            this.triggerMap.put(triggerType, trigger);
        }
        return trigger;
    }
}

