/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.provider.impl;

import cool.lazy.cat.orm.core.base.exception.InitFailedException;
import cool.lazy.cat.orm.core.jdbc.component.convert.TypeConverter;
import cool.lazy.cat.orm.core.jdbc.provider.TypeConverterProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultTypeConverterProvider
implements TypeConverterProvider {
    protected Map<Class<? extends TypeConverter>, TypeConverter> typeConverterMap = new HashMap<Class<? extends TypeConverter>, TypeConverter>();

    @Autowired(required=false)
    private void initTypeConverterMap(List<TypeConverter> typeConverterList) {
        this.typeConverterMap = typeConverterList.stream().collect(Collectors.toMap(Object::getClass, Function.identity()));
    }

    @Override
    public TypeConverter provider(Class<? extends TypeConverter> converterType) {
        TypeConverter converter = this.typeConverterMap.get(converterType);
        if (null == converter) {
            try {
                converter = converterType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new InitFailedException("\u521d\u59cb\u5316typeConverter\u5931\u8d25");
            }
            this.typeConverterMap.put(converterType, converter);
        }
        return converter;
    }
}

