/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.provider.impl;

import cool.lazy.cat.orm.core.base.exception.InitFailedException;
import cool.lazy.cat.orm.core.jdbc.component.validator.Validator;
import cool.lazy.cat.orm.core.jdbc.provider.ValidatorProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultValidatorProvider
implements ValidatorProvider {
    protected Map<Class<? extends Validator>, Validator> validatorMap = new HashMap<Class<? extends Validator>, Validator>();

    @Autowired(required=false)
    private void initValidatorMap(List<Validator> validatorList) {
        this.validatorMap = validatorList.stream().collect(Collectors.toMap(Object::getClass, Function.identity()));
    }

    @Override
    public Validator provider(Class<? extends Validator> validatorType) {
        Validator validator = this.validatorMap.get(validatorType);
        if (null == validator) {
            try {
                validator = validatorType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                throw new InitFailedException("\u521d\u59cb\u5316validator\u5931\u8d25\uff01");
            }
            this.validatorMap.put(validatorType, validator);
        }
        return validator;
    }
}

