/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.provider.impl;

import cool.lazy.cat.orm.core.base.util.Caster;
import cool.lazy.cat.orm.core.jdbc.analyzer.RowAggregator;
import cool.lazy.cat.orm.core.jdbc.component.convert.TypeConverter;
import cool.lazy.cat.orm.core.jdbc.dialect.Dialect;
import cool.lazy.cat.orm.core.jdbc.dialect.DialectRegister;
import cool.lazy.cat.orm.core.jdbc.dto.FlatPojoWrapper;
import cool.lazy.cat.orm.core.jdbc.dto.TableFieldInfoIndexWrapper;
import cool.lazy.cat.orm.core.jdbc.exception.RowMappingException;
import cool.lazy.cat.orm.core.jdbc.exception.TypeConvertException;
import cool.lazy.cat.orm.core.jdbc.holder.SearchSqlParamIndexHolder;
import cool.lazy.cat.orm.core.jdbc.holder.SqlParamHolder;
import cool.lazy.cat.orm.core.jdbc.holder.TableChainHolder;
import cool.lazy.cat.orm.core.jdbc.manager.PojoTableManager;
import cool.lazy.cat.orm.core.jdbc.mapping.TableChain;
import cool.lazy.cat.orm.core.jdbc.mapping.TableFieldInfo;
import cool.lazy.cat.orm.core.jdbc.mapping.TableInfo;
import cool.lazy.cat.orm.core.jdbc.provider.ResultSetExtractorProvider;
import cool.lazy.cat.orm.core.jdbc.provider.TypeConverterProvider;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.support.JdbcUtils;

public class FastMappingResultSetExtractorProvider
implements ResultSetExtractorProvider {
    @Autowired
    protected RowAggregator rowAggregator;
    @Autowired
    protected PojoTableManager pojoTableManager;
    @Autowired
    protected TypeConverterProvider typeConverterProvider;
    protected Dialect dialect;
    protected final Log logger = LogFactory.getLog(this.getClass());

    @Autowired
    private void initDialect(DialectRegister register) {
        this.dialect = register.getDialect();
    }

    @Override
    public <T> ResultSetExtractor<List<T>> provider(TableChainHolder tableChainHolder, SqlParamHolder sqlParamHolder, int initialCapacity) {
        SearchSqlParamIndexHolder searchSqlParamIndexHolder = (SearchSqlParamIndexHolder)sqlParamHolder;
        return resultSet -> {
            long rowMappingTime = 0L;
            int rowNum = 0;
            ArrayList<Object> result = new ArrayList<Object>(1000);
            ResultSetMetaData metaData = resultSet.getMetaData();
            int maxColumn = metaData.getColumnCount();
            TableInfo tableInfo = tableChainHolder.getTableInfo();
            try {
                if (tableInfo.isNested()) {
                    while (resultSet.next()) {
                        long start = System.currentTimeMillis();
                        FlatPojoWrapper[] instanceDef = (FlatPojoWrapper[])this.initInstance(tableChainHolder);
                        this.mappingRow(resultSet, maxColumn, instanceDef, tableChainHolder.getFlatChain(), searchSqlParamIndexHolder.getIndexesArr());
                        result.add(instanceDef);
                        ++rowNum;
                        rowMappingTime += System.currentTimeMillis() - start;
                    }
                } else {
                    while (resultSet.next()) {
                        long start = System.currentTimeMillis();
                        Object instanceDef = this.initInstance(tableChainHolder);
                        this.mappingRow(resultSet, maxColumn, instanceDef, searchSqlParamIndexHolder.getIndexesArr());
                        result.add(instanceDef);
                        ++rowNum;
                        rowMappingTime += System.currentTimeMillis() - start;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RowMappingException("\u884c\u6620\u5c04\u5f02\u5e38\uff1a" + tableInfo.getPojoType().getName() + "\uff0crowNumber\uff1a" + rowNum);
            }
            this.logger.info((Object)("\u6620\u5c04\u603b\u8017\u65f6" + rowMappingTime + "\t\u5bf9\u8c61\uff1a" + rowNum));
            if (tableInfo.isNested()) {
                return this.rowAggregator.mergeRow(tableChainHolder, searchSqlParamIndexHolder.getExcludeFieldInfoWrapper(), (List)Caster.cast(result));
            }
            return result;
        };
    }

    private void mappingRow(ResultSet resultSet, int maxColumn, FlatPojoWrapper[] instanceDef, List<TableChain> flatChain, TableFieldInfoIndexWrapper[] indexes) throws IllegalAccessException, SQLException, InvocationTargetException {
        for (int i = 1; i <= maxColumn; ++i) {
            Object pojo;
            TableFieldInfoIndexWrapper indexWrapper = indexes[i - 1];
            if (null == indexWrapper || null == indexWrapper.getFieldInfo()) continue;
            TableFieldInfo info = indexWrapper.getFieldInfo();
            if (indexWrapper.getChainFlatIndex() != -1) {
                TableChain chain = flatChain.get(indexWrapper.getChainFlatIndex() - 1);
                pojo = instanceDef[chain.getFlatIndex()].getPojoInstance();
            } else {
                pojo = instanceDef[0].getPojoInstance();
            }
            this.invoke(info, pojo, resultSet, i);
        }
    }

    private void mappingRow(ResultSet resultSet, int maxColumn, Object instance, TableFieldInfoIndexWrapper[] indexes) throws IllegalAccessException, SQLException, InvocationTargetException {
        for (int i = 1; i <= maxColumn; ++i) {
            TableFieldInfoIndexWrapper indexWrapper = indexes[i - 1];
            if (null == indexWrapper || null == indexWrapper.getFieldInfo()) continue;
            TableFieldInfo info = indexWrapper.getFieldInfo();
            this.invoke(info, instance, resultSet, i);
        }
    }

    private Object initInstance(TableChainHolder tableChainHolder) throws IllegalAccessException, InstantiationException {
        if (tableChainHolder.getTableInfo().isNested()) {
            int flatPojoCount = tableChainHolder.getFlatChain().size();
            FlatPojoWrapper[] pojoWrapper = new FlatPojoWrapper[flatPojoCount + 1];
            pojoWrapper[0] = new FlatPojoWrapper(0, tableChainHolder.getTableInfo().getPojoType().newInstance());
            for (int i = 0; i < flatPojoCount; ++i) {
                pojoWrapper[i + 1] = new FlatPojoWrapper(0, tableChainHolder.getFlatChain().get(i).getPojoType().newInstance());
            }
            return pojoWrapper;
        }
        return tableChainHolder.getTableInfo().getPojoType().newInstance();
    }

    private void invoke(TableFieldInfo info, Object instance, ResultSet resultSet, int column) throws SQLException, InvocationTargetException, IllegalAccessException {
        if (info.havingTypeConverter()) {
            TypeConverter converter = this.typeConverterProvider.provider(info.getColumn().getTypeConverter());
            if (converter.match(this.dialect)) {
                info.getSetter().invoke(instance, JdbcUtils.getResultSetValue((ResultSet)resultSet, (int)column, info.getJavaType()));
            } else {
                try {
                    info.getSetter().invoke(instance, converter.convertFromDb(instance, resultSet, column, info.getJavaType()));
                }
                catch (SQLException sqlException) {
                    sqlException.printStackTrace();
                    throw new TypeConvertException("\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38\uff1a" + instance.getClass().getName() + "#" + info.getSetter().getName() + "");
                }
            }
        } else {
            info.getSetter().invoke(instance, JdbcUtils.getResultSetValue((ResultSet)resultSet, (int)column, info.getJavaType()));
        }
    }
}

