/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.sqlsource;

import cool.lazy.cat.orm.core.base.util.InvokeHelper;
import cool.lazy.cat.orm.core.jdbc.mapping.TableFieldInfo;
import java.util.Map;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;

public class PojoPropertySqlParameterSource
extends AbstractSqlParameterSource {
    protected final Object pojo;
    protected final Map<String, TableFieldInfo> fieldInfoMap;
    protected final Map<TableFieldInfo, Object> convertedData;

    public PojoPropertySqlParameterSource(Object pojo, Map<String, TableFieldInfo> fieldInfoMap, Map<TableFieldInfo, Object> convertedData) {
        this.pojo = pojo;
        this.fieldInfoMap = fieldInfoMap;
        this.convertedData = convertedData;
    }

    public boolean hasValue(String paramName) {
        return this.fieldInfoMap.containsKey(paramName);
    }

    public Object getValue(String paramName) throws IllegalArgumentException {
        TableFieldInfo fieldInfo = this.fieldInfoMap.get(paramName);
        if (null != this.convertedData && this.convertedData.containsKey(fieldInfo)) {
            return this.convertedData.get(fieldInfo);
        }
        return InvokeHelper.invokeGetter(fieldInfo.getGetter(), this.pojo);
    }

    public int getSqlType(String paramName) {
        Class<Object> javaType = this.fieldInfoMap.get(paramName).getJavaType();
        if (javaType == Boolean.TYPE || javaType == Boolean.class || javaType == Character.TYPE || javaType == Character.class) {
            javaType = String.class;
        }
        return StatementCreatorUtils.javaTypeToSqlParameterType(javaType);
    }

    public String[] getParameterNames() {
        return (String[])this.fieldInfoMap.values().stream().map(TableFieldInfo::getJavaFieldName).toArray(String[]::new);
    }
}

