/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.jdbc.util;

import cool.lazy.cat.orm.core.base.util.CollectionUtil;
import cool.lazy.cat.orm.core.jdbc.dto.CascadeLevelMapper;
import cool.lazy.cat.orm.core.jdbc.dto.CountHolder;
import cool.lazy.cat.orm.core.jdbc.generator.AliasNameGenerator;
import cool.lazy.cat.orm.core.jdbc.holder.TableChainHolder;
import cool.lazy.cat.orm.core.jdbc.manager.subject.PojoTableSubject;
import cool.lazy.cat.orm.core.jdbc.mapping.PojoMapping;
import cool.lazy.cat.orm.core.jdbc.mapping.TableChain;
import cool.lazy.cat.orm.core.jdbc.mapping.TableInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class TableChainBuildHelper {
    public static final String ALL = "ALL_$" + UUID.randomUUID().toString();
    private static AliasNameGenerator aliasNameGenerator;

    public static void initAliasNameGenerator(AliasNameGenerator a) {
        if (null == aliasNameGenerator) {
            aliasNameGenerator = a;
        }
    }

    public static TableChainHolder build(TableInfo tableInfo, List<PojoMapping> mappings, Map<Class<?>, PojoTableSubject> allSubjectMap, CascadeLevelMapper cascadeLevelMapper) {
        TableChainHolder holder = new TableChainHolder(tableInfo);
        ArrayList<TableChain> nestedChain = new ArrayList<TableChain>();
        for (PojoMapping mapping : mappings) {
            nestedChain.addAll(TableChainBuildHelper.analysisTableChain(new ArrayList<TableChain>(), mapping, null, allSubjectMap, cascadeLevelMapper.getLevel(mapping)));
        }
        List<TableChain> flatChain = TableChainBuildHelper.getFlatChain(new ArrayList<TableChain>(), nestedChain, new CountHolder(0));
        return holder.setNestedChain(nestedChain).setFlatChain(flatChain);
    }

    private static List<TableChain> analysisTableChain(List<TableChain> chainList, PojoMapping pojoMapping, TableChain upperChain, Map<Class<?>, PojoTableSubject> allSubjectMap, int depth) {
        PojoTableSubject mappingSubject = allSubjectMap.get(pojoMapping.getJavaType());
        TableChain chain = TableChainBuildHelper.buildTableChain(mappingSubject, pojoMapping);
        chain.setUpperChain(upperChain).setPojoMapping(pojoMapping);
        chainList.add(chain);
        if (--depth <= 0) {
            return chainList;
        }
        TableInfo mappingTable = mappingSubject.getTableInfo();
        if (TableChainBuildHelper.hasMapping(mappingSubject)) {
            List<PojoMapping> pojoMappingList = CollectionUtil.concat(mappingTable.getOneToOneMapping(), mappingTable.getOneToManyMapping(), mappingTable.getManyToOneMapping());
            ArrayList<TableChain> nestedChain = new ArrayList<TableChain>();
            for (PojoMapping mapping : pojoMappingList) {
                nestedChain.addAll(TableChainBuildHelper.analysisTableChain(new ArrayList<TableChain>(), mapping, chain, allSubjectMap, depth));
            }
            chain.setChain(nestedChain);
        }
        return chainList;
    }

    private static TableChain buildTableChain(PojoTableSubject mappingSubject, PojoMapping pojoMapping) {
        TableChain chain = new TableChain().setPojoType(mappingSubject.getPojoType());
        chain.setName(mappingSubject.getTableInfo().getFullName());
        chain.setJoinCondition(pojoMapping.getJoinCondition());
        chain.setBelongField(pojoMapping.getFieldInfo());
        chain.setId(mappingSubject.getTableInfo().getId());
        chain.setPojoType(mappingSubject.getPojoType());
        return chain;
    }

    private static List<TableChain> getFlatChain(List<TableChain> flatChainList, List<TableChain> nestedChainList, CountHolder holder) {
        for (TableChain chain : nestedChainList) {
            ++holder.count;
            chain.setAliasName(aliasNameGenerator.generatorTableName(chain.getPojoMapping().getFieldInfo().getJavaFieldName(), holder.count));
            chain.setFlatIndex(holder.count);
            flatChainList.add(chain);
            if (!chain.hasChain()) continue;
            TableChainBuildHelper.getFlatChain(flatChainList, chain.getChain(), holder);
        }
        return flatChainList;
    }

    private static boolean hasMapping(PojoTableSubject subject) {
        return subject.getTableInfo().getOneToOneMapping() != null || subject.getTableInfo().getOneToManyMapping() != null || subject.getTableInfo().getManyToOneMapping() != null;
    }
}

