/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.manager;

import cool.lazy.cat.orm.core.manager.Manager;
import cool.lazy.cat.orm.core.manager.PojoManager;
import cool.lazy.cat.orm.core.manager.RepositoryManager;
import cool.lazy.cat.orm.core.manager.ServiceManager;
import cool.lazy.cat.orm.core.manager.exception.UnKnowPojoException;
import cool.lazy.cat.orm.core.manager.subject.BusinessSubject;
import cool.lazy.cat.orm.core.manager.subject.PojoSubject;
import cool.lazy.cat.orm.core.manager.subject.RepositorySubject;
import cool.lazy.cat.orm.core.manager.subject.ServiceSubject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class BusinessManager
implements Manager {
    private final Map<Class<?>, BusinessSubject> subjectMap = new HashMap(100);

    @Autowired
    public void initBusinessSubject(PojoManager pojoManager, RepositoryManager repositoryManager, ServiceManager serviceManager) {
        List<PojoSubject> pojoSubjectList = pojoManager.getPojoSubjectList();
        for (PojoSubject pojoSubject : pojoSubjectList) {
            BusinessSubject subject = new BusinessSubject();
            subject.setPojoType(pojoSubject);
            ServiceSubject serviceSubject = serviceManager.getByPojoType(pojoSubject.getPojoType());
            subject.setServiceSubject(serviceSubject);
            subject.setRepositorySubject(repositoryManager.getByPojoType(pojoSubject.getPojoType()));
            this.subjectMap.put(pojoSubject.getPojoType(), subject);
        }
    }

    public BusinessSubject getBusinessSubject(Class<?> pojoType) {
        BusinessSubject subject = this.subjectMap.get(pojoType);
        if (null == subject) {
            throw new UnKnowPojoException("\u672a\u5b9a\u4e49\u7684pojo\u7c7b\u578b\uff1a" + pojoType.getName());
        }
        return subject;
    }

    public ServiceSubject getServiceSubject(Class<?> pojoType) {
        ServiceSubject subject = this.subjectMap.get(pojoType).getServiceSubject();
        if (null == subject) {
            throw new UnKnowPojoException("\u672a\u5b9a\u4e49\u7684pojo\u7c7b\u578b\uff1a" + pojoType.getName());
        }
        return subject;
    }

    public RepositorySubject getRepositorySubject(Class<?> pojoType) {
        RepositorySubject subject = this.subjectMap.get(pojoType).getRepositorySubject();
        if (null == subject) {
            throw new UnKnowPojoException("\u672a\u5b9a\u4e49\u7684pojo\u7c7b\u578b\uff1a" + pojoType.getName());
        }
        return subject;
    }
}

