/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.manager;

import cool.lazy.cat.orm.core.manager.Manager;
import cool.lazy.cat.orm.core.manager.exception.UnKnowPojoException;
import cool.lazy.cat.orm.core.manager.subject.PojoSubject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PojoManager
implements Manager {
    public static List<Class<?>> pojoClasses = Collections.emptyList();
    private final List<PojoSubject> pojoSubjectList = new ArrayList<PojoSubject>();

    public PojoManager() {
        for (Class<?> pojoClass : pojoClasses) {
            PojoSubject subject = new PojoSubject();
            subject.setPojoName(pojoClass.getName());
            subject.setPojoType(pojoClass);
            this.pojoSubjectList.add(subject);
        }
    }

    public List<PojoSubject> getPojoSubjectList() {
        return this.pojoSubjectList;
    }

    public PojoSubject getByName(String pojoName) {
        for (PojoSubject subject : this.pojoSubjectList) {
            if (!Objects.equals(pojoName, subject.getPojoName())) continue;
            return subject;
        }
        throw new UnKnowPojoException("\u672a\u5b9a\u4e49\u7684pojo\u7c7b\u578b\uff1a" + pojoName);
    }

    public PojoSubject getByPojoType(Class<?> pojoType) {
        for (PojoSubject subject : this.pojoSubjectList) {
            if (pojoType != subject.getPojoType()) continue;
            return subject;
        }
        throw new UnKnowPojoException("\u672a\u5b9a\u4e49\u7684pojo\u7c7b\u578b\uff1a" + pojoType.getName());
    }
}

