/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.manager;

import cool.lazy.cat.orm.core.base.repository.BaseRepository;
import cool.lazy.cat.orm.core.manager.Manager;
import cool.lazy.cat.orm.core.manager.PojoManager;
import cool.lazy.cat.orm.core.manager.exception.UnKnowPojoException;
import cool.lazy.cat.orm.core.manager.subject.PojoSubject;
import cool.lazy.cat.orm.core.manager.subject.RepositorySubject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class RepositoryManager
implements Manager {
    @Autowired
    protected BaseRepository<?> baseRepository;
    protected Map<Class<?>, RepositorySubject> repositorySubjectMap;

    @Autowired
    public void initRepositoryMap(PojoManager pojoManager, List<BaseRepository<?>> repositoryList) {
        List<PojoSubject> pojoSubjectList = pojoManager.getPojoSubjectList();
        this.repositorySubjectMap = new HashMap(pojoSubjectList.size());
        for (PojoSubject pojoSubject : pojoSubjectList) {
            Class<?> pojoType = pojoSubject.getPojoType();
            RepositorySubject subject = new RepositorySubject();
            subject.setPojoSubject(pojoSubject).setPojoType(pojoType).setRepository(this.baseRepository);
            repositoryList.stream().filter(r -> r.getPojoType() == subject.getPojoType()).findFirst().ifPresent(subject::setRepository);
            this.repositorySubjectMap.put(pojoType, subject);
        }
    }

    public RepositorySubject getByPojoType(Class<?> pojoType) {
        RepositorySubject subject = this.repositorySubjectMap.get(pojoType);
        if (null == subject) {
            throw new UnKnowPojoException("\u672a\u5b9a\u4e49\u7684pojo\u7c7b\u578b\uff1a" + pojoType.getName());
        }
        return subject;
    }
}

