/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.manager;

import cool.lazy.cat.orm.core.base.service.BaseService;
import cool.lazy.cat.orm.core.manager.subject.ServiceSubject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceManager {
    private ServiceSubject defaultServiceSubject;
    protected Map<Class<?>, ServiceSubject> serviceSubjectMap;

    @Autowired
    public void initServiceMap(List<BaseService<?>> serviceList, BaseService<Object> baseService) {
        this.defaultServiceSubject = new ServiceSubject();
        this.defaultServiceSubject.setService(baseService);
        this.serviceSubjectMap = new HashMap(100);
        serviceList = serviceList.stream().filter(s -> s.getPojoType() != null).collect(Collectors.toList());
        for (BaseService<Object> service : serviceList) {
            ServiceSubject subject = new ServiceSubject();
            subject.setService(service);
            this.serviceSubjectMap.put(service.getPojoType(), subject);
        }
    }

    public ServiceSubject getByPojoType(Class<?> pojoType) {
        ServiceSubject subject = this.serviceSubjectMap.get(pojoType);
        if (null != subject) {
            return subject;
        }
        return this.defaultServiceSubject;
    }
}

