/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.manager.scan;

import cool.lazy.cat.orm.core.base.annotation.Pojo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.Assert;

public class ClassPathPojoScanner
extends ClassPathBeanDefinitionScanner {
    private ResourcePatternResolver resourcePatternResolver;
    private String resourcePattern = "**/*.class";

    public ClassPathPojoScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
    }

    public List<Class<?>> doScanPojo(String ... basePackages) {
        Assert.notEmpty((Object[])basePackages, (String)"At least one base package must be specified");
        ArrayList pojoClasses = new ArrayList();
        for (String basePackage : basePackages) {
            pojoClasses.addAll(this.analysisPojo(basePackage));
        }
        return pojoClasses;
    }

    private List<Class<?>> analysisPojo(String basePackage) {
        String packageSearchPath = "classpath*:" + this.resolveBasePackage(basePackage) + '/' + this.resourcePattern;
        ArrayList beanClass = new ArrayList();
        try {
            Resource[] resources;
            for (Resource resource : resources = this.getResourcePatternResolver().getResources(packageSearchPath)) {
                if (!resource.isReadable()) continue;
                MetadataReader metadataReader = this.getMetadataReaderFactory().getMetadataReader(resource);
                ScannedGenericBeanDefinition sbd = new ScannedGenericBeanDefinition(metadataReader);
                try {
                    Class<?> pojoClass = Class.forName(sbd.getMetadata().getClassName());
                    if (pojoClass.getAnnotation(Pojo.class) == null) continue;
                    beanClass.add(pojoClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(sbd.getMetadata().getClassName());
                }
            }
        }
        catch (IOException ex) {
            throw new BeanDefinitionStoreException("I/O failure during classpath scanning", (Throwable)ex);
        }
        return beanClass;
    }

    private ResourcePatternResolver getResourcePatternResolver() {
        if (this.resourcePatternResolver == null) {
            this.resourcePatternResolver = new PathMatchingResourcePatternResolver();
        }
        return this.resourcePatternResolver;
    }
}

