/*
 * Decompiled with CFR 0.152.
 */
package cool.lazy.cat.orm.core.manager.subject;

import cool.lazy.cat.orm.core.manager.exception.CannotResolverBeanInfoException;
import cool.lazy.cat.orm.core.manager.subject.Subject;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class PojoSubject
implements Subject {
    protected String pojoName;
    protected Class<?> pojoType;
    protected List<MethodDescriptor> setterList;
    protected List<MethodDescriptor> getterList;

    public void setPojoName(String pojoName) {
        this.pojoName = pojoName;
    }

    public void setPojoType(Class<?> pojoType) {
        this.pojoType = pojoType;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(pojoType);
            this.setterList = Arrays.stream(beanInfo.getMethodDescriptors()).filter(m -> m.getMethod().getName().startsWith("set")).collect(Collectors.toList());
            this.getterList = Arrays.stream(beanInfo.getMethodDescriptors()).filter(m -> m.getMethod().getName().startsWith("get")).collect(Collectors.toList());
        }
        catch (IntrospectionException e) {
            throw new CannotResolverBeanInfoException("\u65e0\u6cd5\u89e3\u6790bean\u5bf9\u8c61\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff1a" + pojoType.getName());
        }
    }

    public String getPojoName() {
        return this.pojoName;
    }

    public Class<?> getPojoType() {
        return this.pojoType;
    }

    public List<MethodDescriptor> getSetterList() {
        return this.setterList;
    }

    public void setSetterList(List<MethodDescriptor> setterList) {
        this.setterList = setterList;
    }

    public List<MethodDescriptor> getGetterList() {
        return this.getterList;
    }

    public void setGetterList(List<MethodDescriptor> getterList) {
        this.getterList = getterList;
    }
}

