/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.meta_data;

import cool.scx.data.jdbc.mapping.Schema;
import cool.scx.data.jdbc.meta_data.MetaDataHelper;
import cool.scx.data.jdbc.meta_data.TableMetaData;
import java.sql.Connection;
import java.sql.SQLException;

public final class SchemaMetaData
implements Schema {
    private final String catalog;
    private final String name;
    private TableMetaData[] tables;

    public SchemaMetaData(String catalog, String name) {
        this.catalog = catalog;
        this.name = name;
    }

    public String catalog() {
        return this.catalog;
    }

    public String name() {
        return this.name;
    }

    public TableMetaData[] tables() {
        return this.tables;
    }

    public SchemaMetaData refreshTables(Connection connection) throws SQLException {
        return this.refreshTables(connection, false);
    }

    public SchemaMetaData refreshTables(Connection connection, boolean deep) throws SQLException {
        this.tables = MetaDataHelper.initTables(connection, this.catalog, this.name, null, null);
        if (deep) {
            for (TableMetaData table : this.tables) {
                table.refreshColumns(connection);
            }
        }
        return this;
    }
}

