/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc;

import cool.scx.common.reflect.FieldInfo;
import cool.scx.common.util.AnnotationUtils;
import cool.scx.common.util.CaseUtils;
import cool.scx.data.jdbc.AnnotationConfigDataType;
import cool.scx.data.jdbc.annotation.Column;
import cool.scx.jdbc.mapping.type.TypeColumn;
import java.lang.reflect.Type;

public class AnnotationConfigColumn
implements TypeColumn {
    private final FieldInfo javaField;
    private final String columnName;
    private final AnnotationConfigDataType dataType;
    private final String defaultValue;
    private final String onUpdate;
    private final boolean notNull;
    private final boolean autoIncrement;
    private final boolean primary;
    private final boolean unique;
    private final boolean index;

    public AnnotationConfigColumn(FieldInfo javaField) {
        this.javaField = javaField;
        this.javaField.setAccessible(true);
        Column column = (Column)javaField.getAnnotation(Column.class);
        String defaultColumnName = CaseUtils.toSnake((String)javaField.name());
        AnnotationConfigDataType defaultDataType = new AnnotationConfigDataType((Type)this.javaField.type());
        if (column != null) {
            String _columnName = AnnotationUtils.getAnnotationValue((String)column.columnName());
            String _defaultValue = AnnotationUtils.getAnnotationValue((String)column.defaultValue());
            String _onUpdate = AnnotationUtils.getAnnotationValue((String)column.onUpdate());
            this.columnName = _columnName != null ? _columnName : defaultColumnName;
            this.dataType = column.dataType().length > 0 ? new AnnotationConfigDataType(column.dataType()[0]) : defaultDataType;
            this.defaultValue = _defaultValue;
            this.onUpdate = _onUpdate;
            this.notNull = column.notNull();
            this.autoIncrement = column.autoIncrement();
            this.primary = column.primary();
            this.unique = column.unique();
            this.index = column.index();
        } else {
            this.columnName = defaultColumnName;
            this.dataType = defaultDataType;
            this.defaultValue = null;
            this.onUpdate = null;
            this.notNull = false;
            this.autoIncrement = false;
            this.primary = false;
            this.unique = false;
            this.index = false;
        }
    }

    public FieldInfo javaField() {
        return this.javaField;
    }

    public String name() {
        return this.columnName;
    }

    public AnnotationConfigDataType dataType() {
        return this.dataType;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String onUpdate() {
        return this.onUpdate;
    }

    public boolean notNull() {
        return this.notNull;
    }

    public boolean autoIncrement() {
        return this.autoIncrement;
    }

    public boolean primary() {
        return this.primary;
    }

    public boolean unique() {
        return this.unique;
    }

    public boolean index() {
        return this.index;
    }

    public Object javaFieldValue(Object target) {
        try {
            return this.javaField.get(target);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

