/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.jdbc.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.common.util.ArrayUtils;
import cool.scx.common.util.ObjectUtils;
import cool.scx.common.util.StringUtils;
import cool.scx.data.jdbc.AnnotationConfigTable;
import cool.scx.data.jdbc.parser.ColumnNameParser;
import cool.scx.data.query.WhereClause;
import cool.scx.data.query.WhereOption;
import cool.scx.data.query.WhereType;
import cool.scx.data.query.exception.ValidParamListIsEmptyException;
import cool.scx.data.query.parser.WhereParser;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.sql.SQL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;

public class JDBCDaoWhereParser
extends WhereParser {
    private final AnnotationConfigTable tableInfo;
    private final Dialect dialect;

    public JDBCDaoWhereParser(AnnotationConfigTable tableInfo, Dialect dialect) {
        this.tableInfo = tableInfo;
        this.dialect = dialect;
    }

    public WhereClause parseIsNull(String name, WhereType whereType, Object value1, Object value2, WhereOption.Info info) {
        String columnName = ColumnNameParser.parseColumnName(this.tableInfo, name, info.useJsonExtract(), info.useOriginalName());
        Object[] whereParams = new Object[]{};
        String whereClause = columnName + " " + this.getWhereKeyWord(whereType);
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseEqual(String name, WhereType whereType, Object value1, Object value2, WhereOption.Info info) {
        Object[] whereParams;
        Object v1;
        String columnName = ColumnNameParser.parseColumnName(this.tableInfo, name, info.useJsonExtract(), info.useOriginalName());
        if (value1 instanceof SQL) {
            SQL a = (SQL)value1;
            v1 = "(" + a.sql() + ")";
            whereParams = a.params();
        } else {
            v1 = "?";
            whereParams = new Object[]{value1};
        }
        String whereClause = columnName + " " + this.getWhereKeyWord(whereType) + " " + (String)v1;
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseLike(String name, WhereType whereType, Object value1, Object value2, WhereOption.Info info) {
        Object[] whereParams;
        Object v1;
        String columnName = ColumnNameParser.parseColumnName(this.tableInfo, name, info.useJsonExtract(), info.useOriginalName());
        if (value1 instanceof SQL) {
            SQL a = (SQL)value1;
            v1 = "(" + a.sql() + ")";
            whereParams = a.params();
        } else {
            v1 = "?";
            whereParams = new Object[]{value1};
        }
        String whereClause = columnName + " " + this.getWhereKeyWord(whereType) + " CONCAT('%'," + (String)v1 + ",'%')";
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseIn(String name, WhereType whereType, Object value1, Object value2, WhereOption.Info info) {
        Object[] whereParams;
        String v1;
        String columnName = ColumnNameParser.parseColumnName(this.tableInfo, name, info.useJsonExtract(), info.useOriginalName());
        if (value1 instanceof SQL) {
            SQL a = (SQL)value1;
            v1 = "(" + a.sql() + ")";
            whereParams = a.params();
        } else {
            whereParams = Arrays.stream(ArrayUtils.toObjectArray((Object)value1)).filter(Objects::nonNull).distinct().toArray();
            if (whereParams.length == 0) {
                throw new ValidParamListIsEmptyException(whereType);
            }
            v1 = "(" + StringUtils.repeat((String)"?", (String)", ", (int)whereParams.length) + ")";
        }
        String whereClause = columnName + " " + this.getWhereKeyWord(whereType) + " " + v1;
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parseBetween(String name, WhereType whereType, Object value1, Object value2, WhereOption.Info info) {
        Object v2;
        Object v1;
        SQL a;
        String columnName = ColumnNameParser.parseColumnName(this.tableInfo, name, info.useJsonExtract(), info.useOriginalName());
        ArrayList<Object> whereParams = new ArrayList<Object>();
        if (value1 instanceof SQL) {
            a = (SQL)value1;
            v1 = "(" + a.sql() + ")";
            Collections.addAll(whereParams, a.params());
        } else {
            v1 = "?";
            whereParams.add(value1);
        }
        if (value2 instanceof SQL) {
            a = (SQL)value2;
            v2 = "(" + a.sql() + ")";
            Collections.addAll(whereParams, a.params());
        } else {
            v2 = "?";
            whereParams.add(value2);
        }
        String whereClause = columnName + " " + this.getWhereKeyWord(whereType) + " " + (String)v1 + " AND " + (String)v2;
        return new WhereClause(whereClause, whereParams.toArray());
    }

    public WhereClause parseJsonContains(String name, WhereType whereType, Object value1, Object value2, WhereOption.Info info) {
        Object[] whereParams;
        Object v1;
        String columnName;
        ColumnNameParser.ColumnNameAndFieldPath c = ColumnNameParser.splitIntoColumnNameAndFieldPath(name);
        String string = columnName = info.useOriginalName() ? c.columnName() : this.tableInfo.getColumn(c.columnName()).name();
        if (StringUtils.isBlank((String)c.columnName())) {
            throw new IllegalArgumentException("\u4f7f\u7528 JSON_CONTAINS \u65f6, \u67e5\u8be2\u540d\u79f0\u4e0d\u5408\u6cd5 !!! \u5b57\u6bb5\u540d : " + name);
        }
        if (value1 instanceof SQL) {
            SQL a = (SQL)value1;
            v1 = "(" + a.sql() + ")";
            whereParams = a.params();
        } else {
            v1 = "?";
            if (info.useOriginalValue()) {
                whereParams = new Object[]{value1};
            } else {
                try {
                    whereParams = new Object[]{ObjectUtils.toJson((Object)value1, (ObjectUtils.Option[])new ObjectUtils.Option[]{ObjectUtils.Option.IGNORE_JSON_IGNORE, ObjectUtils.Option.IGNORE_NULL_VALUE})};
                }
                catch (JsonProcessingException e) {
                    throw new IllegalArgumentException("\u4f7f\u7528 JSON_CONTAINS \u65f6, \u67e5\u8be2\u53c2\u6570\u4e0d\u5408\u6cd5(\u65e0\u6cd5\u6b63\u786e\u8f6c\u6362\u4e3a JSON) !!! \u5b57\u6bb5\u540d : " + name, e);
                }
            }
        }
        String whereClause = this.getWhereKeyWord(whereType) + "(" + columnName;
        whereClause = StringUtils.notBlank((String)c.fieldPath()) ? whereClause + ", " + (String)v1 + ", '$" + c.fieldPath() + "')" : whereClause + ", " + (String)v1 + ")";
        return new WhereClause(whereClause, whereParams);
    }

    public WhereClause parse(Object obj) {
        if (obj instanceof SQL) {
            SQL sql = (SQL)obj;
            return this.parseSQL(sql);
        }
        return super.parse(obj);
    }

    public final WhereClause parseSQL(SQL sql) {
        return new WhereClause("(" + sql.sql() + ")", sql.params());
    }
}

